/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.sql.generator.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Date;
import org.linuxprobe.crud.core.annoatation.BlobHandler;
import org.linuxprobe.crud.core.annoatation.Column;
import org.linuxprobe.crud.core.annoatation.NumberHandler;
import org.linuxprobe.crud.core.annoatation.StringHandler;
import org.linuxprobe.crud.utils.FieldUtil;
import org.linuxprobe.crud.utils.SqlFieldUtil;
import org.springframework.util.StreamUtils;

public class AnnoatationRuleCheck {
    private static void stringCheck(Object record, Field field) {
        Column column;
        String fieldValue = (String)FieldUtil.getFieldValue(record, field);
        if (field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)).notNull() && fieldValue == null) {
            throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " can't be null");
        }
        if (fieldValue != null && field.isAnnotationPresent(StringHandler.class)) {
            StringHandler stringHandler = field.getAnnotation(StringHandler.class);
            if (stringHandler.minLeng() > 0 && fieldValue.length() < stringHandler.minLeng()) {
                throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " minLeng is " + stringHandler.minLeng());
            }
            if (stringHandler.maxLeng() > 0 && fieldValue.length() > stringHandler.maxLeng()) {
                throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " maxLeng is " + stringHandler.maxLeng());
            }
            if (!stringHandler.regex().isEmpty() && !fieldValue.matches(stringHandler.regex())) {
                throw new IllegalArgumentException("in " + record.getClass().getName() + ",the value " + fieldValue + " of " + field.getName() + " cannot match the regex " + stringHandler.regex());
            }
        }
    }

    private static void dateCheck(Object record, Field field) {
        Column column;
        Date fieldValue = (Date)FieldUtil.getFieldValue(record, field);
        if (field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)).notNull() && fieldValue == null) {
            throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " can't be null");
        }
    }

    private static void enumCheck(Object record, Field field) {
        Column column;
        Enum fieldValue = (Enum)FieldUtil.getFieldValue(record, field);
        if (field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)).notNull() && fieldValue == null) {
            throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " can't be null");
        }
    }

    private static void numberCheck(Object record, Field field) {
        Column column;
        Number fieldValue = (Number)FieldUtil.getFieldValue(record, field);
        if (field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)).notNull() && fieldValue == null) {
            throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " can't be null");
        }
        if (fieldValue != null && field.isAnnotationPresent(NumberHandler.class)) {
            BigDecimal bigDecimalMaxValue;
            BigDecimal bigDecimalMinValue;
            NumberHandler numberHandler = field.getAnnotation(NumberHandler.class);
            BigDecimal bigDecimalValue = new BigDecimal(fieldValue + "");
            if (!numberHandler.minValue().isEmpty() && (bigDecimalMinValue = new BigDecimal(numberHandler.minValue())).compareTo(bigDecimalValue) > 0) {
                throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " minValue is " + numberHandler.minValue());
            }
            if (!numberHandler.maxValue().isEmpty() && (bigDecimalMaxValue = new BigDecimal(numberHandler.maxValue())).compareTo(bigDecimalValue) < 0) {
                throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " maxValue is " + numberHandler.maxValue());
            }
        }
    }

    private static void booleanCehck(Object record, Field field) {
        Column column;
        Boolean fieldValue = (Boolean)FieldUtil.getFieldValue(record, field);
        if (field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)).notNull() && fieldValue == null) {
            throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " can't be null");
        }
    }

    private static void charCheck(Object record, Field field) {
        Column column;
        Character fieldValue = (Character)FieldUtil.getFieldValue(record, field);
        if (field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)).notNull() && fieldValue == null) {
            throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " can't be null");
        }
    }

    private static void blobCheck(Object record, Field field) {
        Column column;
        Object fieldValue = FieldUtil.getFieldValue(record, field);
        if (field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)).notNull() && fieldValue == null) {
            throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " can't be null");
        }
        if (fieldValue != null) {
            byte[] bin = null;
            if (Blob.class.isAssignableFrom(field.getType())) {
                Blob blob = (Blob)fieldValue;
                try {
                    bin = StreamUtils.copyToByteArray((InputStream)blob.getBinaryStream());
                }
                catch (IOException | SQLException e) {
                    throw new IllegalArgumentException(e);
                }
            } else if (byte[].class.isAssignableFrom(field.getType())) {
                bin = (byte[])fieldValue;
            } else if (Byte[].class.isAssignableFrom(field.getType())) {
                Byte[] binB = (Byte[])fieldValue;
                bin = new byte[binB.length];
                for (int i = 0; i < binB.length; ++i) {
                    bin[i] = binB[i];
                }
            }
            if (field.isAnnotationPresent(BlobHandler.class)) {
                BlobHandler blobHandler = field.getAnnotation(BlobHandler.class);
                if (blobHandler.minSize() != 0 && bin.length < blobHandler.minSize()) {
                    throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " minSize is " + blobHandler.minSize());
                }
                if (blobHandler.maxSize() != 0 && bin.length > blobHandler.maxSize()) {
                    throw new IllegalArgumentException("in " + record.getClass().getName() + "," + field.getName() + " maxSize is " + blobHandler.maxSize());
                }
            }
        }
    }

    public static void check(Object entity, Field field) {
        if (SqlFieldUtil.isFacultyOfString(field.getType())) {
            AnnoatationRuleCheck.stringCheck(entity, field);
        } else if (SqlFieldUtil.isFacultyOfNumber(field.getType())) {
            AnnoatationRuleCheck.numberCheck(entity, field);
        } else if (SqlFieldUtil.isFacultyOfBoolean(field.getType())) {
            AnnoatationRuleCheck.booleanCehck(entity, field);
        } else if (SqlFieldUtil.isFacultyOfDate(field.getType())) {
            AnnoatationRuleCheck.dateCheck(entity, field);
        } else if (SqlFieldUtil.isFacultyOfEnum(field.getType())) {
            AnnoatationRuleCheck.enumCheck(entity, field);
        } else if (SqlFieldUtil.isFacultyOfChar(field.getType())) {
            AnnoatationRuleCheck.charCheck(entity, field);
        } else if (SqlFieldUtil.isFacultyOfBlob(field.getType())) {
            AnnoatationRuleCheck.blobCheck(entity, field);
        }
    }
}

