/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.query.param;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public abstract class BaseParam<T extends Serializable> {
    private Operator operator = Operator.equal;
    private Condition condition = Condition.and;

    public boolean isEmpty() {
        if (this.getOperator() == Operator.isNull || this.getOperator() == Operator.isNotNull) {
            return false;
        }
        if (this.getOperator() == Operator.between || this.getOperator() == Operator.notBetween) {
            return this.getMinValue() == null || this.getMaxValue() == null;
        }
        if (this.getOperator() == Operator.in || this.getOperator() == Operator.notIn) {
            return this.getMultiValues() == null;
        }
        return this.getValue() == null;
    }

    public abstract T getValue();

    public abstract T getMinValue();

    public abstract T getMaxValue();

    public abstract List<T> getMultiValues();

    public Class<?> getParamCalss() {
        Type type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        Class<?> modelClass = null;
        try {
            modelClass = Class.forName(type.getTypeName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return modelClass;
    }

    public void setOperator(Operator operator) {
        this.operator = operator == null ? Operator.equal : operator;
    }

    public void setCondition(Condition condition) {
        this.condition = condition == null ? Condition.and : condition;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public static class Condition {
        private String condition;
        public static final Condition and = new Condition("AND");
        public static final Condition or = new Condition("OR");

        private Condition(String condition) {
            this.condition = condition;
        }

        public String toString() {
            return this.condition;
        }

        public String getCondition() {
            return this.condition;
        }
    }

    public static class Operator {
        private String operator = "=";
        public static final Operator equal = new Operator("=");
        public static final Operator unequal = new Operator("!=");
        public static final Operator more = new Operator(">");
        public static final Operator less = new Operator("<");
        public static final Operator moreOrEqual = new Operator(">=");
        public static final Operator lessOrEqual = new Operator("<=");
        public static final Operator between = new Operator("BETWEEN");
        public static final Operator notBetween = new Operator("NOT BETWEEN");
        public static final Operator in = new Operator("IN");
        public static final Operator notIn = new Operator("NOT IN");
        public static final Operator like = new Operator("LIKE");
        public static final Operator unlike = new Operator("NOT LIKE");
        public static final Operator isNull = new Operator("IS");
        public static final Operator isNotNull = new Operator("IS NOT");
        public static final Operator regexp = new Operator("REGEXP");

        private Operator(String operator) {
            this.operator = operator;
        }

        public String getOperator() {
            return this.operator;
        }
    }
}

