/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.proxy;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import org.linuxprobe.crud.core.annoatation.OneToMany;
import org.linuxprobe.crud.core.annoatation.OneToOne;
import org.linuxprobe.crud.core.content.EntityInfo;
import org.linuxprobe.crud.core.content.UniversalCrudContent;
import org.linuxprobe.crud.mybatis.session.SqlSessionExtend;
import org.linuxprobe.crud.utils.FieldUtil;
import org.linuxprobe.crud.utils.StringHumpTool;
import org.springframework.beans.BeanUtils;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

public class ModelCglib
implements MethodInterceptor {
    private SqlSessionExtend sqlSessionExtend;
    private Object instance;
    private Set<String> handledMethod = new HashSet<String>();

    public ModelCglib(SqlSessionExtend sqlSessionExtend) {
        this.sqlSessionExtend = sqlSessionExtend;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Object result = proxy.invokeSuper(obj, args);
        if (result != null) {
            return result;
        }
        if (this.handledMethod.contains(method.getName())) {
            return result;
        }
        if (method.getName().startsWith("set")) {
            this.handledMethod.add(method.getName().replace("set", "get"));
            return result;
        }
        if (method.getName().startsWith("get")) {
            Field field = FieldUtil.getFieldByMethod(obj.getClass(), method);
            if (field.isAnnotationPresent(OneToOne.class)) {
                this.handledMethod.add(method.getName());
                result = this.handldeOneToOne(obj, field);
                return result;
            }
            if (field.isAnnotationPresent(OneToMany.class)) {
                this.handledMethod.add(method.getName());
                result = this.handldeOneToMany(obj, field);
                return result;
            }
            return result;
        }
        return result;
    }

    private Object handldeOneToOne(Object obj, Field field) throws Exception {
        EntityInfo.FieldInfo correlationFieldInfo;
        String columnName = StringHumpTool.humpToLine2(field.getName(), "_") + "_id";
        if (!field.getAnnotation(OneToOne.class).value().isEmpty()) {
            columnName = field.getAnnotation(OneToOne.class).value();
        }
        if ((correlationFieldInfo = UniversalCrudContent.getEntityInfo(obj.getClass()).getColumnMapFieldInfo().get(columnName)) == null) {
            throw new IllegalArgumentException(columnName + " column does not have a corresponding field.");
        }
        Serializable correlationFieldValue = (Serializable)FieldUtil.getFieldValue(obj, correlationFieldInfo.getField());
        if (correlationFieldValue != null) {
            Object result = this.sqlSessionExtend.selectByPrimaryKey(correlationFieldValue, field.getType());
            FieldUtil.setField(obj, field, result);
            return result;
        }
        return null;
    }

    private Object handldeOneToMany(Object obj, Field field) throws Exception {
        List<?> daoResults;
        Field principalField = UniversalCrudContent.getEntityInfo(obj.getClass()).getPrimaryKey().getField();
        String subordinateColumn = UniversalCrudContent.getEntityInfo(obj.getClass()).getTableName() + "_id";
        OneToMany oneToMany = field.getAnnotation(OneToMany.class);
        EntityInfo entityInfo = UniversalCrudContent.getEntityInfo(obj.getClass());
        if (!"".equals(oneToMany.value())) {
            principalField = entityInfo.getColumnMapFieldInfo().get(oneToMany.value()).getField();
        } else if (!"".equals(oneToMany.principal())) {
            principalField = entityInfo.getColumnMapFieldInfo().get(oneToMany.principal()).getField();
        }
        if (!"".equals(oneToMany.subordinate())) {
            subordinateColumn = oneToMany.subordinate();
        }
        Class<?> subordinateClass = FieldUtil.getFiledGenericclass(field, 0);
        Serializable principalFieldValue = (Serializable)FieldUtil.getFieldValue(obj, principalField);
        if (principalFieldValue == null) {
            return null;
        }
        Collection<?> result = daoResults = this.sqlSessionExtend.selectByColumn(subordinateColumn, principalFieldValue, subordinateClass);
        if (!Collection.class.isAssignableFrom(field.getType())) {
            throw new IllegalArgumentException(field.getType() + "\u662f\u4e0d\u88ab\u652f\u6301\u7684\u7c7b\u578b");
        }
        if (ArrayList.class.isAssignableFrom(field.getType())) {
            result = new ArrayList(daoResults);
        } else if (LinkedList.class.isAssignableFrom(field.getType())) {
            result = new LinkedList(daoResults);
        } else if (Stack.class.isAssignableFrom(field.getType())) {
            Stack stack = new Stack();
            stack.addAll(daoResults);
            result = stack;
        } else if (Vector.class.isAssignableFrom(field.getType())) {
            Vector vector = new Vector();
            vector.addAll(daoResults);
            result = vector;
        } else if (List.class.isAssignableFrom(field.getType())) {
            result = new LinkedList(daoResults);
        } else if (LinkedHashSet.class.isAssignableFrom(field.getType())) {
            result = new LinkedHashSet(daoResults);
        } else if (HashSet.class.isAssignableFrom(field.getType())) {
            result = new HashSet(daoResults);
        } else if (TreeSet.class.isAssignableFrom(field.getType())) {
            result = new TreeSet(daoResults);
        } else if (NavigableSet.class.isAssignableFrom(field.getType())) {
            result = new TreeSet(daoResults);
        } else if (SortedSet.class.isAssignableFrom(field.getType())) {
            result = new TreeSet(daoResults);
        } else if (Set.class.isAssignableFrom(field.getType())) {
            result = new HashSet(daoResults);
        } else if (Queue.class.isAssignableFrom(field.getType())) {
            PriorityQueue priorityQueue = new PriorityQueue();
            priorityQueue.addAll(daoResults);
            result = priorityQueue;
        } else if (Deque.class.isAssignableFrom(field.getType())) {
            ArrayDeque arrayDeque = new ArrayDeque();
            arrayDeque.addAll(daoResults);
            result = arrayDeque;
        }
        FieldUtil.setField(obj, field, result);
        return result;
    }

    public <T> T getInstance(Class<T> entityType) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(entityType);
        enhancer.setCallback((Callback)this);
        this.instance = enhancer.create();
        return (T)this.instance;
    }

    public void copy(Object source) {
        BeanUtils.copyProperties((Object)source, (Object)this.instance);
        this.handledMethod.clear();
    }

    public void clearMark() {
        this.handledMethod.clear();
    }
}

