/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.spring.boot.start;

import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.ExecutorType;
import org.linuxprobe.crud.mybatis.session.UniversalCrudConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

@ConfigurationProperties(prefix="mybatis")
public class MybatisProperties {
    public static final String MYBATIS_PREFIX = "mybatis";
    private static final ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
    private String configLocation;
    private String[] mapperLocations;
    private String typeAliasesPackage;
    private Class<?> typeAliasesSuperType;
    private String typeHandlersPackage;
    private boolean checkConfigLocation = false;
    private ExecutorType executorType;
    private Class<? extends LanguageDriver> defaultScriptingLanguageDriver;
    private Properties configurationProperties;
    @NestedConfigurationProperty
    private UniversalCrudConfiguration configuration;
    private String universalCrudScan;
    private String[] universalCrudScans;

    public Resource[] resolveMapperLocations() {
        return (Resource[])Stream.of((Object[])Optional.ofNullable(this.mapperLocations).orElse(new String[0])).flatMap(location -> Stream.of(this.getResources((String)location))).toArray(Resource[]::new);
    }

    private Resource[] getResources(String location) {
        try {
            return resourceResolver.getResources(location);
        }
        catch (IOException e) {
            return new Resource[0];
        }
    }

    public String getUniversalCrudScan() {
        if (this.universalCrudScans != null && this.universalCrudScans.length > 0) {
            String universalCrudScan = this.universalCrudScan;
            if (universalCrudScan == null) {
                universalCrudScan = "";
            } else if (!universalCrudScan.endsWith(";")) {
                universalCrudScan = universalCrudScan + ";";
            }
            for (String scan : this.universalCrudScans) {
                universalCrudScan = universalCrudScan + scan + ";";
            }
            this.universalCrudScan = universalCrudScan;
            this.universalCrudScans = null;
        }
        return this.universalCrudScan;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public String[] getMapperLocations() {
        return this.mapperLocations;
    }

    public String getTypeAliasesPackage() {
        return this.typeAliasesPackage;
    }

    public Class<?> getTypeAliasesSuperType() {
        return this.typeAliasesSuperType;
    }

    public String getTypeHandlersPackage() {
        return this.typeHandlersPackage;
    }

    public boolean isCheckConfigLocation() {
        return this.checkConfigLocation;
    }

    public ExecutorType getExecutorType() {
        return this.executorType;
    }

    public Class<? extends LanguageDriver> getDefaultScriptingLanguageDriver() {
        return this.defaultScriptingLanguageDriver;
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public UniversalCrudConfiguration getConfiguration() {
        return this.configuration;
    }

    public String[] getUniversalCrudScans() {
        return this.universalCrudScans;
    }

    public MybatisProperties setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
        return this;
    }

    public MybatisProperties setMapperLocations(String[] mapperLocations) {
        this.mapperLocations = mapperLocations;
        return this;
    }

    public MybatisProperties setTypeAliasesPackage(String typeAliasesPackage) {
        this.typeAliasesPackage = typeAliasesPackage;
        return this;
    }

    public MybatisProperties setTypeAliasesSuperType(Class<?> typeAliasesSuperType) {
        this.typeAliasesSuperType = typeAliasesSuperType;
        return this;
    }

    public MybatisProperties setTypeHandlersPackage(String typeHandlersPackage) {
        this.typeHandlersPackage = typeHandlersPackage;
        return this;
    }

    public MybatisProperties setCheckConfigLocation(boolean checkConfigLocation) {
        this.checkConfigLocation = checkConfigLocation;
        return this;
    }

    public MybatisProperties setExecutorType(ExecutorType executorType) {
        this.executorType = executorType;
        return this;
    }

    public MybatisProperties setDefaultScriptingLanguageDriver(Class<? extends LanguageDriver> defaultScriptingLanguageDriver) {
        this.defaultScriptingLanguageDriver = defaultScriptingLanguageDriver;
        return this;
    }

    public MybatisProperties setConfigurationProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
        return this;
    }

    public MybatisProperties setConfiguration(UniversalCrudConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public MybatisProperties setUniversalCrudScan(String universalCrudScan) {
        this.universalCrudScan = universalCrudScan;
        return this;
    }

    public MybatisProperties setUniversalCrudScans(String[] universalCrudScans) {
        this.universalCrudScans = universalCrudScans;
        return this;
    }
}

