/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.linuxprobe.crud.core.annoatation.Column;
import org.linuxprobe.crud.core.annoatation.PrimaryKey;
import org.linuxprobe.crud.core.annoatation.Table;
import org.linuxprobe.crud.core.sql.field.ColumnField;
import org.linuxprobe.crud.utils.FieldUtils;
import org.linuxprobe.crud.utils.SqlEscapeUtil;
import org.linuxprobe.crud.utils.StringHumpTool;

public class EntityUtils {
    public static Field getFieldByColumnName(Class<?> entityClass, String columnName) {
        if (entityClass == null || columnName == null) {
            return null;
        }
        List<Field> fields = FieldUtils.getAllFields(entityClass);
        Field columnAnnotationMatch = null;
        Field nameMatch = null;
        Field lineToHumpMatch = null;
        for (Field field : fields) {
            Column column;
            if (field.getName().equals(columnName)) {
                nameMatch = field;
            }
            if (StringHumpTool.humpToLine2(field.getName(), "_").equals(columnName)) {
                lineToHumpMatch = field;
            }
            if (!field.isAnnotationPresent(Column.class) || (column = field.getAnnotation(Column.class)).value() == null || column.value().trim().isEmpty() || !column.value().trim().equals(columnName)) continue;
            columnAnnotationMatch = field;
        }
        if (columnAnnotationMatch != null) {
            return columnAnnotationMatch;
        }
        if (nameMatch != null) {
            return nameMatch;
        }
        if (lineToHumpMatch != null) {
            return lineToHumpMatch;
        }
        return null;
    }

    public static void setField(Object entity, String column, Object arg) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method methodOfSet;
        Field field = EntityUtils.getFieldByColumnName(entity.getClass(), column);
        if (field != null && (methodOfSet = FieldUtils.getMethodOfFieldSet(entity.getClass(), field)) != null) {
            Class<?> argType = methodOfSet.getParameterTypes()[0];
            if (arg == null || argType.isAssignableFrom(arg.getClass())) {
                methodOfSet.invoke(entity, arg);
            } else if (Boolean.class.isAssignableFrom(argType)) {
                String strArg = arg.toString();
                if (strArg.equals("0") || strArg.trim().isEmpty()) {
                    methodOfSet.invoke(entity, false);
                } else {
                    methodOfSet.invoke(entity, true);
                }
            } else if (Enum.class.isAssignableFrom(argType)) {
                Class<?> enumType = field.getType();
                if (Number.class.isAssignableFrom(arg.getClass())) {
                    Enum[] enums;
                    int ordinal = ((Number)arg).intValue();
                    for (Enum tempEnum : enums = (Enum[])enumType.getEnumConstants()) {
                        if (tempEnum.ordinal() != ordinal) continue;
                        methodOfSet.invoke(entity, tempEnum);
                        break;
                    }
                } else if (String.class.isAssignableFrom(arg.getClass())) {
                    methodOfSet.invoke(entity, Enum.valueOf(enumType, (String)arg));
                }
            }
        }
    }

    public static String getTable(Class<?> entityType) {
        boolean classHasTableAnno = entityType.isAnnotationPresent(Table.class);
        if (classHasTableAnno) {
            Table annotation = entityType.getAnnotation(Table.class);
            String table = annotation.value();
            if (table.trim().isEmpty()) {
                return StringHumpTool.humpToLine2(entityType.getSimpleName(), "_");
            }
            return table.trim();
        }
        return StringHumpTool.humpToLine2(entityType.getSimpleName(), "_");
    }

    public static ColumnField getPrimaryKey(Object entity) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<Field> fields = FieldUtils.getAllFields(entity.getClass());
        ColumnField result = null;
        Field primaryKey = null;
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            if (!field.isAnnotationPresent(PrimaryKey.class)) continue;
            primaryKey = field;
            break;
        }
        if (primaryKey != null) {
            Column column;
            String strColumn;
            Object clounmValue;
            result = new ColumnField();
            String fieldName = primaryKey.getName();
            result.setName(fieldName);
            String funSuffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Method getCurrnetClounm = null;
            try {
                getCurrnetClounm = entity.getClass().getMethod("get" + funSuffix, new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new IllegalArgumentException(entity.getClass().getName() + "\u4e3b\u952e\u6210\u5458\u6ca1\u6709get\u65b9\u6cd5", e);
            }
            String value = null;
            Object fieldValue = null;
            try {
                fieldValue = getCurrnetClounm.invoke(entity, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalArgumentException(entity.getClass().getName() + "\u4e3b\u952e\u6210\u5458\u7684get\u65b9\u6cd5\u8c03\u7528\u5931\u8d25", e);
            }
            if (String.class.isAssignableFrom(primaryKey.getType())) {
                clounmValue = (String)fieldValue;
                if (clounmValue != null) {
                    clounmValue = SqlEscapeUtil.escape((String)clounmValue);
                    value = "'" + (String)clounmValue + "'";
                } else {
                    value = null;
                }
            } else if (Number.class.isAssignableFrom(primaryKey.getType())) {
                clounmValue = (Number)fieldValue;
                value = clounmValue != null ? clounmValue.toString() : null;
            } else if (Boolean.class.isAssignableFrom(primaryKey.getType())) {
                clounmValue = (Boolean)fieldValue;
                value = clounmValue != null ? (((Boolean)clounmValue).booleanValue() ? "1" : "0") : null;
            } else if (Date.class.isAssignableFrom(primaryKey.getType())) {
                clounmValue = (Date)fieldValue;
                value = clounmValue != null ? "'" + dateFormat.format((Date)clounmValue) + "'" : null;
            } else if (Enum.class.isAssignableFrom(primaryKey.getType())) {
                clounmValue = (Enum)fieldValue;
                if (clounmValue != null) {
                    Column column2;
                    value = ((Enum)clounmValue).ordinal() + "";
                    if (primaryKey.isAnnotationPresent(Column.class) && (column2 = primaryKey.getAnnotation(Column.class)).enumHandler().equals((Object)Column.EnumHandler.Name)) {
                        value = "'" + ((Enum)clounmValue).toString() + "'";
                    }
                } else {
                    value = null;
                }
            } else {
                throw new IllegalArgumentException(entity.getClass().getName() + "\u4e3b\u952e\u6210\u5458\u4e0d\u662f\u88ab\u652f\u6301\u7684\u7c7b\u578b");
            }
            result.setValue(value);
            result.setColumn(StringHumpTool.humpToLine2(fieldName, "_"));
            if (primaryKey.isAnnotationPresent(Column.class) && (strColumn = (column = primaryKey.getAnnotation(Column.class)).value()) != null && !strColumn.trim().isEmpty()) {
                result.setColumn(strColumn);
            }
        } else {
            throw new IllegalArgumentException(entity.getClass().getName() + "\u6240\u6709\u6210\u5458\u53d8\u91cf\u5747\u672a\u6807\u6ce8@PrimaryKey\u6ce8\u89e3");
        }
        return result;
    }
}

