/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.sql.generator;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.linuxprobe.crud.core.annoatation.Column;
import org.linuxprobe.crud.core.annoatation.PrimaryKey;
import org.linuxprobe.crud.core.annoatation.Transient;
import org.linuxprobe.crud.core.sql.field.ColumnField;
import org.linuxprobe.crud.core.sql.generator.SqlGenerator;
import org.linuxprobe.crud.exception.OperationNotSupportedException;
import org.linuxprobe.crud.utils.EntityUtils;
import org.linuxprobe.crud.utils.FieldUtils;
import org.linuxprobe.crud.utils.SqlEscapeUtil;
import org.linuxprobe.crud.utils.StringHumpTool;

public class UpdateSqlGenerator
extends SqlGenerator {
    private static UpdateSqlGenerator instance = new UpdateSqlGenerator();
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private UpdateSqlGenerator() {
    }

    public static UpdateSqlGenerator getInstance() {
        return instance;
    }

    public static String toGlobalUpdateSql(Object entity) {
        String table = EntityUtils.getTable(entity.getClass());
        StringBuilder sqlBuilder = new StringBuilder("UPDATE " + UpdateSqlGenerator.getEscapeCharacter() + table + UpdateSqlGenerator.getEscapeCharacter() + " SET ");
        List<ColumnField> columnFields = UpdateSqlGenerator.getColumnFields(entity, true);
        ColumnField primaryKey = null;
        for (ColumnField columnField : columnFields) {
            if (!columnField.getIsPrimaryKey().booleanValue()) continue;
            primaryKey = columnField;
        }
        if (primaryKey == null) {
            throw new OperationNotSupportedException("\u8bf7\u4f7f\u7528@PrimaryKey\u6307\u5b9a\u4e3b\u952e");
        }
        for (int i = 0; i < columnFields.size(); ++i) {
            ColumnField columnField;
            columnField = columnFields.get(i);
            sqlBuilder.append(UpdateSqlGenerator.getEscapeCharacter() + columnField.getColumn() + UpdateSqlGenerator.getEscapeCharacter() + " = " + columnField.getValue() + ", ");
        }
        if (sqlBuilder.indexOf(",") != -1) {
            sqlBuilder.replace(sqlBuilder.length() - 2, sqlBuilder.length(), " ");
        }
        sqlBuilder.append("WHERE " + UpdateSqlGenerator.getEscapeCharacter() + primaryKey.getColumn() + UpdateSqlGenerator.getEscapeCharacter() + " = " + primaryKey.getValue());
        return sqlBuilder.toString();
    }

    public static String toLocalUpdateSql(Object entity) {
        String table = EntityUtils.getTable(entity.getClass());
        StringBuilder sqlBuilder = new StringBuilder("UPDATE " + UpdateSqlGenerator.getEscapeCharacter() + table + UpdateSqlGenerator.getEscapeCharacter() + " SET ");
        List<ColumnField> columnFields = UpdateSqlGenerator.getColumnFields(entity, false);
        ColumnField primaryKey = null;
        for (ColumnField columnField : columnFields) {
            if (!columnField.getIsPrimaryKey().booleanValue()) continue;
            primaryKey = columnField;
        }
        if (primaryKey == null) {
            throw new OperationNotSupportedException("\u8bf7\u4f7f\u7528@PrimaryKey\u6307\u5b9a\u4e3b\u952e");
        }
        for (int i = 0; i < columnFields.size(); ++i) {
            ColumnField columnField;
            columnField = columnFields.get(i);
            if (columnField.getValue() == null) continue;
            sqlBuilder.append(UpdateSqlGenerator.getEscapeCharacter() + columnField.getColumn() + UpdateSqlGenerator.getEscapeCharacter() + " = " + columnField.getValue() + ", ");
        }
        if (sqlBuilder.indexOf(",") != -1) {
            sqlBuilder.replace(sqlBuilder.length() - 2, sqlBuilder.length(), " ");
        }
        sqlBuilder.append("WHERE " + UpdateSqlGenerator.getEscapeCharacter() + primaryKey.getColumn() + UpdateSqlGenerator.getEscapeCharacter() + " = " + primaryKey.getValue());
        return sqlBuilder.toString();
    }

    private static List<ColumnField> getColumnFields(Object entity, boolean isGlobalUpdate) {
        LinkedList<ColumnField> result = new LinkedList<ColumnField>();
        List<Field> fields = FieldUtils.getAllFields(entity.getClass());
        for (int i = 0; i < fields.size(); ++i) {
            Column column;
            Field field = fields.get(i);
            ColumnField columnField = new ColumnField();
            String fieldName = field.getName();
            columnField.setName(fieldName);
            boolean needAppend = true;
            String funSuffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Method getCurrnetClounm = null;
            try {
                getCurrnetClounm = entity.getClass().getMethod("get" + funSuffix, new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                continue;
            }
            String value = null;
            Object fieldValue = null;
            try {
                fieldValue = getCurrnetClounm.invoke(entity, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                continue;
            }
            if (String.class.isAssignableFrom(field.getType())) {
                String clounmValue = (String)fieldValue;
                if (clounmValue != null) {
                    if (field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)).length() > 0 && clounmValue.length() > column.length()) {
                        if (column.lengthHandler().equals((Object)Column.LengthHandler.Sub)) {
                            clounmValue = clounmValue.substring(0, column.length());
                        } else {
                            throw new IllegalArgumentException(field.getName() + "\u5b57\u6bb5\u7684\u8d4b\u503c\u8d85\u51fa\u89c4\u5b9a\u957f\u5ea6" + column.length());
                        }
                    }
                    clounmValue = SqlEscapeUtil.escape(clounmValue);
                    value = "'" + clounmValue + "'";
                } else {
                    value = null;
                }
            } else if (Number.class.isAssignableFrom(field.getType())) {
                Number clounmValue = (Number)fieldValue;
                value = clounmValue != null ? clounmValue.toString() : null;
            } else if (Boolean.class.isAssignableFrom(field.getType())) {
                Boolean clounmValue = (Boolean)fieldValue;
                value = clounmValue != null ? (clounmValue.booleanValue() ? "1" : "0") : null;
            } else if (Date.class.isAssignableFrom(field.getType())) {
                Date clounmValue = (Date)fieldValue;
                value = clounmValue != null ? "'" + dateFormat.format(clounmValue) + "'" : null;
            } else if (Enum.class.isAssignableFrom(field.getType())) {
                Enum clounmValue = (Enum)fieldValue;
                if (clounmValue != null) {
                    value = clounmValue.ordinal() + "";
                    if (field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)).enumHandler().equals((Object)Column.EnumHandler.Name)) {
                        value = "'" + clounmValue.toString() + "'";
                    }
                } else {
                    value = null;
                }
            } else {
                needAppend = false;
            }
            if (!needAppend || field.isAnnotationPresent(Transient.class)) continue;
            boolean isPrimaryKey = false;
            if (field.isAnnotationPresent(PrimaryKey.class)) {
                isPrimaryKey = true;
                if (value == null) {
                    throw new IllegalArgumentException("\u66f4\u65b0\u6a21\u5f0f\u4e0b\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            columnField.setColumn(StringHumpTool.humpToLine2(fieldName, "_"));
            if (field.isAnnotationPresent(Column.class)) {
                column = field.getAnnotation(Column.class);
                if (column.updateIgnore()) continue;
                if (isGlobalUpdate && column.notNull() && value == null) {
                    throw new IllegalArgumentException(fieldName + "\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String strColumn = column.value();
                if (strColumn != null && !strColumn.trim().isEmpty()) {
                    columnField.setColumn(strColumn);
                }
            }
            columnField.setIsPrimaryKey(isPrimaryKey);
            columnField.setValue(value);
            result.add(columnField);
        }
        return result;
    }
}

