/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.sql.generator;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.linuxprobe.crud.core.annoatation.Column;
import org.linuxprobe.crud.core.annoatation.JoinColumn;
import org.linuxprobe.crud.core.annoatation.PrimaryKey;
import org.linuxprobe.crud.core.annoatation.Search;
import org.linuxprobe.crud.core.query.BaseQuery;
import org.linuxprobe.crud.core.query.param.QueryParam;
import org.linuxprobe.crud.core.sql.generator.AliasGenerate;
import org.linuxprobe.crud.core.sql.generator.SqlGenerator;
import org.linuxprobe.crud.exception.OperationNotSupportedException;
import org.linuxprobe.crud.utils.EntityUtils;
import org.linuxprobe.crud.utils.FieldUtils;
import org.linuxprobe.crud.utils.StringHumpTool;

public class SelectSqlGenerator
extends SqlGenerator {
    private static ThreadLocal<Map<Object, String>> alias = new ThreadLocal();

    private static Map<Object, String> getAlias() {
        Map<Object, String> result = alias.get();
        if (result == null) {
            alias.set(new HashMap());
            result = alias.get();
        }
        return result;
    }

    private static String getAlias(Object key) {
        Map<Object, String> alias = SelectSqlGenerator.getAlias();
        String result = alias.get(key);
        if (result == null) {
            alias.put(key, AliasGenerate.getAlias());
            result = alias.get(key);
        }
        return result;
    }

    public static String toSelectSql(Object searcher) {
        String alias = SelectSqlGenerator.getAlias(searcher);
        StringBuilder sqlBuilder = new StringBuilder("SELECT DISTINCT " + SelectSqlGenerator.getEscapeCharacter() + alias + SelectSqlGenerator.getEscapeCharacter() + ".* FROM " + SelectSqlGenerator.getEscapeCharacter() + SelectSqlGenerator.getTable(searcher.getClass()) + SelectSqlGenerator.getEscapeCharacter() + " AS " + SelectSqlGenerator.getEscapeCharacter() + alias + SelectSqlGenerator.getEscapeCharacter() + " ");
        sqlBuilder.append((CharSequence)SelectSqlGenerator.toJoin(searcher));
        sqlBuilder.append((CharSequence)SelectSqlGenerator.getFormatWhere(searcher));
        sqlBuilder.append((CharSequence)SelectSqlGenerator.toOrder(searcher));
        sqlBuilder.append(SelectSqlGenerator.toLimit(searcher));
        SelectSqlGenerator.alias.remove();
        return sqlBuilder.toString();
    }

    public static String toSelectCountSql(Object searcher, String clounm) {
        String countFun = "COUNT(DISTINCT " + SelectSqlGenerator.getEscapeCharacter() + SelectSqlGenerator.getAlias(searcher) + SelectSqlGenerator.getEscapeCharacter() + "." + SelectSqlGenerator.getEscapeCharacter() + clounm + SelectSqlGenerator.getEscapeCharacter() + ")";
        StringBuilder sqlBuilder = new StringBuilder("SELECT " + countFun + " FROM " + SelectSqlGenerator.getEscapeCharacter() + SelectSqlGenerator.getTable(searcher.getClass()) + SelectSqlGenerator.getEscapeCharacter() + " AS " + SelectSqlGenerator.getEscapeCharacter() + SelectSqlGenerator.getAlias(searcher) + SelectSqlGenerator.getEscapeCharacter() + " ");
        sqlBuilder.append((CharSequence)SelectSqlGenerator.toJoin(searcher));
        sqlBuilder.append((CharSequence)SelectSqlGenerator.getFormatWhere(searcher));
        alias.remove();
        return sqlBuilder.toString();
    }

    public static String toSelectCountSql(Object searcher) {
        String countFun = "COUNT(DISTINCT " + SelectSqlGenerator.getEscapeCharacter() + SelectSqlGenerator.getAlias(searcher) + SelectSqlGenerator.getEscapeCharacter() + "." + SelectSqlGenerator.getEscapeCharacter() + SelectSqlGenerator.getPrimaryKeyName(SelectSqlGenerator.getModelType(searcher.getClass())) + SelectSqlGenerator.getEscapeCharacter() + ")";
        StringBuilder sqlBuilder = new StringBuilder("SELECT " + countFun + " FROM " + SelectSqlGenerator.getEscapeCharacter() + SelectSqlGenerator.getTable(searcher.getClass()) + SelectSqlGenerator.getEscapeCharacter() + " AS " + SelectSqlGenerator.getEscapeCharacter() + SelectSqlGenerator.getAlias(searcher) + SelectSqlGenerator.getEscapeCharacter() + " ");
        sqlBuilder.append((CharSequence)SelectSqlGenerator.toJoin(searcher));
        sqlBuilder.append((CharSequence)SelectSqlGenerator.getFormatWhere(searcher));
        alias.remove();
        return sqlBuilder.toString();
    }

    private static StringBuilder toJoin(Object searcher) {
        List<Field> fields = FieldUtils.getAllFields(searcher.getClass());
        StringBuilder joinBuffer = new StringBuilder();
        for (Field field : fields) {
            if (!field.getType().isAnnotationPresent(Search.class)) continue;
            String fieldName = field.getName();
            String funSuffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Method getCurrnetParam = null;
            try {
                getCurrnetParam = searcher.getClass().getMethod("get" + funSuffix, new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                continue;
            }
            Object member = null;
            try {
                member = getCurrnetParam.invoke(searcher, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                continue;
            }
            if (member == null) continue;
            String principalColumn = StringHumpTool.humpToLine2(fieldName + "Id", "_");
            String subordinateColumn = SelectSqlGenerator.getPrimaryKeyName(SelectSqlGenerator.getModelType(field.getType()));
            if (field.isAnnotationPresent(JoinColumn.class)) {
                JoinColumn joinColumn = field.getAnnotation(JoinColumn.class);
                String value = joinColumn.value().trim();
                String principal = joinColumn.principal().trim();
                if (!value.isEmpty()) {
                    principalColumn = value;
                } else if (!principal.isEmpty()) {
                    principalColumn = principal;
                }
                String subordinate = joinColumn.subordinate().trim();
                if (!subordinate.isEmpty()) {
                    subordinateColumn = subordinate;
                }
            }
            String joinTable = SelectSqlGenerator.getTable(field.getType());
            String joinTableAlias = SelectSqlGenerator.getAlias(member);
            String joinStr = "LEFT";
            if (BaseQuery.class.isAssignableFrom(member.getClass())) {
                BaseQuery joinSearchObj = (BaseQuery)member;
                BaseQuery.JoinType joinType = joinSearchObj.getJoinType();
                if (joinType.equals((Object)BaseQuery.JoinType.RightJoin)) {
                    joinStr = "RIGHT";
                } else if (joinType.equals((Object)BaseQuery.JoinType.FullJoin)) {
                    joinStr = "FULL";
                } else if (joinType.equals((Object)BaseQuery.JoinType.InnerJoin)) {
                    joinStr = "INNER";
                } else if (joinType.equals((Object)BaseQuery.JoinType.CrossJoin)) {
                    joinStr = "CROSS";
                }
            }
            joinBuffer.append(joinStr + " JOIN " + SelectSqlGenerator.getEscapeCharacter() + joinTable + SelectSqlGenerator.getEscapeCharacter() + " AS " + SelectSqlGenerator.getEscapeCharacter() + joinTableAlias + SelectSqlGenerator.getEscapeCharacter() + " ON ");
            joinBuffer.append(SelectSqlGenerator.getEscapeCharacter() + joinTableAlias + SelectSqlGenerator.getEscapeCharacter() + "." + SelectSqlGenerator.getEscapeCharacter() + subordinateColumn + SelectSqlGenerator.getEscapeCharacter() + " = ");
            joinBuffer.append(SelectSqlGenerator.getEscapeCharacter() + SelectSqlGenerator.getAlias(searcher) + SelectSqlGenerator.getEscapeCharacter() + "." + SelectSqlGenerator.getEscapeCharacter() + principalColumn + SelectSqlGenerator.getEscapeCharacter() + " ");
            joinBuffer.append((CharSequence)SelectSqlGenerator.toJoin(member));
        }
        return joinBuffer;
    }

    private static StringBuilder toOrder(Object searcher) {
        BaseQuery baseQuery;
        String strOrder;
        StringBuilder result = new StringBuilder();
        if (BaseQuery.class.isAssignableFrom(searcher.getClass()) && (strOrder = (baseQuery = (BaseQuery)searcher).getOrder()) != null) {
            String[] orders = strOrder.split(",");
            for (int i = 0; i < orders.length; ++i) {
                String[] parts = orders[i].split(" ");
                String fieldName = parts[0];
                String orderName = SelectSqlGenerator.getOrderMember(searcher, fieldName);
                if (orderName == null) {
                    throw new IllegalArgumentException(searcher.getClass().getName() + "\u7c7b\u67e5\u8be2\u5bf9\u8c61\u91cc\u6ca1\u6709\u4e0e'" + fieldName + "'\u5bf9\u5e94\u7684\u5b57\u6bb5,\u5982\u679c\u8fd9\u662f\u4e00\u4e2a\u6df1\u5c42\u6b21\u6392\u5e8f\uff0c\u8fd9\u53ef\u80fd\u662f\u5173\u8054\u67e5\u8be2\u5bf9\u8c61\u672a\u8d4b\u503c\u5f15\u8d77\u7684");
                }
                result.append(orderName + " " + parts[1] + ", ");
            }
        }
        if (result.indexOf(", ") != -1) {
            result.delete(result.length() - 2, result.length());
            result.insert(0, "ORDER BY ");
        }
        result.append(" ");
        return result;
    }

    private static String getOrderMember(Object searcher, String fieldName) {
        String[] fieldNames = fieldName.split("\\.");
        List<Field> searcherFields = FieldUtils.getAllFields(searcher.getClass());
        for (Field searcherField : searcherFields) {
            if (fieldNames.length == 1) {
                Column column;
                if (!searcherField.getName().equals(fieldName)) continue;
                if (!QueryParam.class.isAssignableFrom(searcherField.getType())) break;
                String orderName = SelectSqlGenerator.getEscapeCharacter() + SelectSqlGenerator.getAlias(searcher) + SelectSqlGenerator.getEscapeCharacter() + "." + SelectSqlGenerator.getEscapeCharacter() + StringHumpTool.humpToLine2(fieldName, "_") + SelectSqlGenerator.getEscapeCharacter();
                if (searcherField.isAnnotationPresent(Column.class) && !(column = searcherField.getAnnotation(Column.class)).value().trim().isEmpty()) {
                    orderName = SelectSqlGenerator.getEscapeCharacter() + SelectSqlGenerator.getAlias(searcher) + SelectSqlGenerator.getEscapeCharacter() + "." + SelectSqlGenerator.getEscapeCharacter() + column.value().trim() + SelectSqlGenerator.getEscapeCharacter();
                }
                return orderName;
            }
            if (!searcherField.getName().equals(fieldNames[0])) continue;
            searcherField.setAccessible(true);
            try {
                Object sonSearcher = searcherField.get(searcher);
                if (sonSearcher == null) continue;
                return SelectSqlGenerator.getOrderMember(sonSearcher, fieldName.substring(fieldName.indexOf(".") + 1));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
            }
        }
        return null;
    }

    private static String toLimit(Object searcher) {
        BaseQuery baseQuery;
        if (BaseQuery.class.isAssignableFrom(searcher.getClass()) && (baseQuery = (BaseQuery)searcher).getLimit() != null) {
            if (SqlGenerator.DataBaseType.Mysql.equals((Object)SqlGenerator.getDataBaseType())) {
                return "LIMIT " + baseQuery.getLimit().getStartRow() + "," + baseQuery.getLimit().getPageSize() + " ";
            }
            if (SqlGenerator.DataBaseType.Postgre.equals((Object)SqlGenerator.getDataBaseType())) {
                return "LIMIT " + baseQuery.getLimit().getPageSize() + " OFFSET " + baseQuery.getLimit().getStartRow() + " ";
            }
        }
        return "";
    }

    private static LinkedList<String> toWhere(Object searcher) {
        List<Field> fields = FieldUtils.getAllFields(searcher.getClass());
        LinkedList<String> result = new LinkedList<String>();
        for (Field field : fields) {
            Column column;
            String fieldName = field.getName();
            String columnName = StringHumpTool.humpToLine2(fieldName, "_");
            if (field.isAnnotationPresent(Column.class) && !(column = field.getAnnotation(Column.class)).value().trim().isEmpty()) {
                columnName = column.value();
            }
            String funSuffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Method getCurrnetParam = null;
            try {
                getCurrnetParam = searcher.getClass().getMethod("get" + funSuffix, new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                continue;
            }
            Object member = null;
            try {
                member = getCurrnetParam.invoke(searcher, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                continue;
            }
            if (member == null) continue;
            if (QueryParam.class.isAssignableFrom(field.getType())) {
                QueryParam baseMember = (QueryParam)member;
                if (baseMember.isEmpty()) continue;
                result.add(baseMember.getCondition() + " " + SelectSqlGenerator.getEscapeCharacter() + SelectSqlGenerator.getAlias(searcher) + SelectSqlGenerator.getEscapeCharacter() + "." + SelectSqlGenerator.getEscapeCharacter() + columnName + SelectSqlGenerator.getEscapeCharacter() + " " + baseMember.toSqlPart() + " ");
                continue;
            }
            if (!field.getType().isAnnotationPresent(Search.class)) continue;
            result.addAll(SelectSqlGenerator.toWhere(member));
        }
        return result;
    }

    private static StringBuilder getFormatWhere(Object searcher) {
        LinkedList<String> wheres = SelectSqlGenerator.toWhere(searcher);
        Collections.sort(wheres, new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                return str1.trim().compareToIgnoreCase(str2.trim());
            }
        });
        StringBuilder resultBuffer = new StringBuilder();
        for (String where : wheres) {
            resultBuffer.append(where);
        }
        if (resultBuffer.indexOf("AND") != -1 || resultBuffer.indexOf("OR") != -1) {
            resultBuffer.delete(0, resultBuffer.indexOf(" "));
            resultBuffer.insert(0, "WHERE");
        }
        return resultBuffer;
    }

    private static String getPrimaryKeyName(Class<?> modelType) {
        List<Field> fields = FieldUtils.getAllFields(modelType);
        String primaryKeyName = null;
        for (Field field : fields) {
            Column column;
            String strColumn;
            if (!field.isAnnotationPresent(PrimaryKey.class)) continue;
            primaryKeyName = field.getName();
            if (!field.isAnnotationPresent(Column.class) || (strColumn = (column = field.getAnnotation(Column.class)).value().trim()).isEmpty()) break;
            primaryKeyName = strColumn;
            break;
        }
        if (primaryKeyName == null) {
            throw new OperationNotSupportedException(modelType.getName() + "\u7c7b\u7684\u6210\u5458\u6ca1\u6709@PrimaryKey\u6ce8\u89e3");
        }
        return primaryKeyName;
    }

    private static Class<?> getModelType(Class<?> searcherType) {
        if (searcherType == null) {
            throw new OperationNotSupportedException("\u4f20\u5165\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (searcherType.isAnnotationPresent(Search.class)) {
            Search search = searcherType.getAnnotation(Search.class);
            if (search.value() != null) {
                return search.value();
            }
            throw new OperationNotSupportedException("\u8be5\u7c7b@Search\u6ce8\u89e3\u6ca1\u6709\u8d4b\u503c");
        }
        throw new OperationNotSupportedException("\u8be5\u7c7b\u6ca1\u6709\u6807\u6ce8@Search\u6ce8\u89e3");
    }

    private static String getTable(Class<?> searcherType) {
        Class<?> entityType = SelectSqlGenerator.getModelType(searcherType);
        return EntityUtils.getTable(entityType);
    }
}

