/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.sql.generator;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.linuxprobe.crud.core.annoatation.Column;
import org.linuxprobe.crud.core.annoatation.PrimaryKey;
import org.linuxprobe.crud.core.annoatation.Transient;
import org.linuxprobe.crud.core.sql.field.ColumnField;
import org.linuxprobe.crud.core.sql.generator.SqlGenerator;
import org.linuxprobe.crud.exception.OperationNotSupportedException;
import org.linuxprobe.crud.utils.EntityUtils;
import org.linuxprobe.crud.utils.FieldUtils;
import org.linuxprobe.crud.utils.SqlEscapeUtil;
import org.linuxprobe.crud.utils.StringHumpTool;

public class InsertSqlGenerator
extends SqlGenerator {
    private static InsertSqlGenerator instance = new InsertSqlGenerator();
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private InsertSqlGenerator() {
    }

    public static InsertSqlGenerator getInstance() {
        return instance;
    }

    public static String toInsertSql(Object entity) {
        String table = EntityUtils.getTable(entity.getClass());
        StringBuilder sqlBuilder = new StringBuilder("INSERT INTO " + InsertSqlGenerator.getEscapeCharacter() + table + InsertSqlGenerator.getEscapeCharacter() + " ");
        StringBuilder clounms = new StringBuilder("(");
        StringBuilder values = new StringBuilder(" VALUES(");
        List<ColumnField> columnFields = InsertSqlGenerator.getColumnFields(entity);
        if (columnFields.isEmpty()) {
            throw new OperationNotSupportedException("\u8be5\u5b9e\u4f53\u7c7b\u6ca1\u6709\u4efb\u4f55\u5b57\u6bb5");
        }
        for (int i = 0; i < columnFields.size(); ++i) {
            ColumnField columnField = columnFields.get(i);
            if (i + 1 == columnFields.size()) {
                clounms.append(InsertSqlGenerator.getEscapeCharacter() + columnField.getColumn() + InsertSqlGenerator.getEscapeCharacter() + ")");
                values.append(columnField.getValue() + ")");
                continue;
            }
            clounms.append(InsertSqlGenerator.getEscapeCharacter() + columnField.getColumn() + InsertSqlGenerator.getEscapeCharacter() + ", ");
            values.append(columnField.getValue() + ", ");
        }
        sqlBuilder.append((CharSequence)clounms);
        sqlBuilder.append((CharSequence)values);
        return sqlBuilder.toString();
    }

    public static String toBatchInsertSql(List<?> entitys) {
        if (entitys == null || entitys.isEmpty()) {
            throw new OperationNotSupportedException("\u6ca1\u6709\u9700\u8981\u88ab\u4fdd\u5b58\u7684\u5b9e\u4f53");
        }
        StringBuilder sqlBuilder = new StringBuilder();
        for (int i = 0; i < entitys.size(); ++i) {
            Object entity = entitys.get(i);
            if (i == 0) {
                sqlBuilder.append(InsertSqlGenerator.toInsertSql(entity));
                continue;
            }
            String sql = InsertSqlGenerator.toInsertSql(entity);
            String sqlValue = sql.substring(sql.indexOf("VALUES") + 6);
            sqlBuilder.append(", " + sqlValue);
        }
        return sqlBuilder.toString();
    }

    private static List<ColumnField> getColumnFields(Object entity) {
        LinkedList<ColumnField> result = new LinkedList<ColumnField>();
        List<Field> fields = FieldUtils.getAllFields(entity.getClass());
        for (int i = 0; i < fields.size(); ++i) {
            Column column;
            Field field = fields.get(i);
            ColumnField columnField = new ColumnField();
            String fieldName = field.getName();
            columnField.setName(fieldName);
            boolean needAppend = true;
            String funSuffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Method getCurrnetClounm = null;
            try {
                getCurrnetClounm = entity.getClass().getMethod("get" + funSuffix, new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                continue;
            }
            String value = null;
            Object fieldValue = null;
            try {
                fieldValue = getCurrnetClounm.invoke(entity, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                continue;
            }
            if (String.class.isAssignableFrom(field.getType())) {
                String clounmValue = (String)fieldValue;
                if (clounmValue != null) {
                    if (field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)).length() > 0 && clounmValue.length() > column.length()) {
                        if (column.lengthHandler().equals((Object)Column.LengthHandler.Sub)) {
                            clounmValue = clounmValue.substring(0, column.length());
                        } else {
                            throw new IllegalArgumentException(field.getName() + "\u5b57\u6bb5\u7684\u8d4b\u503c\u8d85\u51fa\u89c4\u5b9a\u957f\u5ea6" + column.length());
                        }
                    }
                    clounmValue = SqlEscapeUtil.escape(clounmValue);
                    value = "'" + clounmValue + "'";
                } else {
                    value = null;
                }
            } else if (Number.class.isAssignableFrom(field.getType())) {
                Number clounmValue = (Number)fieldValue;
                value = clounmValue != null ? clounmValue.toString() : null;
            } else if (Boolean.class.isAssignableFrom(field.getType())) {
                Boolean clounmValue = (Boolean)fieldValue;
                value = clounmValue != null ? (clounmValue.booleanValue() ? "1" : "0") : null;
            } else if (Date.class.isAssignableFrom(field.getType())) {
                Date clounmValue = (Date)fieldValue;
                value = clounmValue != null ? "'" + dateFormat.format(clounmValue) + "'" : null;
            } else if (Enum.class.isAssignableFrom(field.getType())) {
                Enum clounmValue = (Enum)fieldValue;
                if (clounmValue != null) {
                    value = clounmValue.ordinal() + "";
                    if (field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)).enumHandler().equals((Object)Column.EnumHandler.Name)) {
                        value = "'" + clounmValue.toString() + "'";
                    }
                } else {
                    value = null;
                }
            } else {
                needAppend = false;
            }
            if (!needAppend || field.isAnnotationPresent(Transient.class)) continue;
            boolean isPrimaryKey = false;
            if (field.isAnnotationPresent(PrimaryKey.class)) {
                isPrimaryKey = true;
                if (value == null) {
                    PrimaryKey primaryKey = field.getAnnotation(PrimaryKey.class);
                    if (primaryKey.value().equals((Object)PrimaryKey.Strategy.UUID)) {
                        try {
                            String uuid = UUID.randomUUID().toString();
                            Method setFun = entity.getClass().getMethod("set" + funSuffix, String.class);
                            setFun.invoke(entity, uuid);
                            value = "'" + uuid + "'";
                        }
                        catch (Exception e) {
                            throw new OperationNotSupportedException("\u672a\u627e\u5230\u4e3b\u952e\u7684set\u65b9\u6cd5", e);
                        }
                    } else if (primaryKey.value().equals((Object)PrimaryKey.Strategy.ASSIGNED)) {
                        throw new NullPointerException("primaryKey can't not be null");
                    }
                }
            }
            columnField.setColumn(StringHumpTool.humpToLine2(fieldName, "_"));
            if (field.isAnnotationPresent(Column.class)) {
                column = field.getAnnotation(Column.class);
                if (column.notNull() && value == null) {
                    throw new IllegalArgumentException(fieldName + "\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String strColumn = column.value();
                if (strColumn != null && !strColumn.trim().isEmpty()) {
                    columnField.setColumn(strColumn);
                }
            }
            columnField.setIsPrimaryKey(isPrimaryKey);
            columnField.setValue(value);
            result.add(columnField);
        }
        LinkedList<ColumnField> distinctResult = new LinkedList<ColumnField>();
        if (result != null) {
            for (ColumnField columnField : result) {
                if (distinctResult.contains(columnField)) continue;
                distinctResult.add(columnField);
            }
        }
        return distinctResult;
    }
}

