/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.sql.generator;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.linuxprobe.crud.core.sql.field.ColumnField;
import org.linuxprobe.crud.core.sql.generator.SqlGenerator;
import org.linuxprobe.crud.utils.EntityUtils;

public class DeleteSqlGenerator
extends SqlGenerator {
    public static String toDeleteSql(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("\u6ca1\u6709\u9700\u8981\u88ab\u5220\u9664\u7684\u5b9e\u4f53");
        }
        ColumnField primaryKey = EntityUtils.getPrimaryKey(entity);
        String table = EntityUtils.getTable(entity.getClass());
        String sql = "DELETE FROM " + DeleteSqlGenerator.getEscapeCharacter() + table + DeleteSqlGenerator.getEscapeCharacter() + " WHERE " + DeleteSqlGenerator.getEscapeCharacter() + primaryKey.getColumn() + DeleteSqlGenerator.getEscapeCharacter() + " = " + primaryKey.getValue();
        return sql;
    }

    public static String toDeleteSqlByPrimaryKey(String id, Class<?> type) {
        if (id == null) {
            throw new IllegalArgumentException("\u6ca1\u6709\u9700\u8981\u88ab\u5220\u9664\u7684\u5b9e\u4f53");
        }
        Object entity = null;
        try {
            entity = type.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException(type.getName() + "\u6ca1\u6709\u65e0\u53c2\u6784\u9020\u51fd\u6570", e);
        }
        ColumnField primaryKey = EntityUtils.getPrimaryKey(entity);
        String table = EntityUtils.getTable(type);
        String sql = "DELETE FROM " + DeleteSqlGenerator.getEscapeCharacter() + table + DeleteSqlGenerator.getEscapeCharacter() + " WHERE " + DeleteSqlGenerator.getEscapeCharacter() + primaryKey.getColumn() + DeleteSqlGenerator.getEscapeCharacter() + " = '" + id + "'";
        return sql;
    }

    public static String toBatchDeleteSql(List<?> entitys) {
        if (entitys == null || entitys.isEmpty()) {
            throw new IllegalArgumentException("\u6ca1\u6709\u9700\u8981\u88ab\u5220\u9664\u7684\u5b9e\u4f53");
        }
        StringBuilder sqlBuilder = new StringBuilder("DELETE FROM " + DeleteSqlGenerator.getEscapeCharacter());
        for (int i = 0; i < entitys.size(); ++i) {
            Object entity = entitys.get(i);
            ColumnField primaryKey = EntityUtils.getPrimaryKey(entity);
            if (i == 0) {
                String table = EntityUtils.getTable(entity.getClass());
                sqlBuilder.append(table + DeleteSqlGenerator.getEscapeCharacter() + " WHERE " + DeleteSqlGenerator.getEscapeCharacter() + primaryKey.getColumn() + DeleteSqlGenerator.getEscapeCharacter() + " IN(");
            }
            sqlBuilder.append(primaryKey.getValue() + ", ");
        }
        if (sqlBuilder.lastIndexOf(", ") != -1) {
            sqlBuilder.replace(sqlBuilder.length() - 2, sqlBuilder.length(), "");
        }
        sqlBuilder.append(")");
        return sqlBuilder.toString();
    }

    public static String toBatchDeleteSqlByPrimaryKey(List<String> ids, Class<?> type) {
        if (ids == null || ids.isEmpty()) {
            throw new IllegalArgumentException("\u6ca1\u6709\u9700\u8981\u88ab\u5220\u9664\u7684\u5b9e\u4f53");
        }
        Object entity = null;
        try {
            entity = type.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException(type.getName() + "\u6ca1\u6709\u65e0\u53c2\u6784\u9020\u51fd\u6570", e);
        }
        ColumnField primaryKey = EntityUtils.getPrimaryKey(entity);
        String table = EntityUtils.getTable(type);
        StringBuilder sqlBuilder = new StringBuilder("DELETE FROM " + DeleteSqlGenerator.getEscapeCharacter() + table + DeleteSqlGenerator.getEscapeCharacter() + " WHERE " + DeleteSqlGenerator.getEscapeCharacter() + primaryKey.getColumn() + DeleteSqlGenerator.getEscapeCharacter() + " IN (");
        for (String id : ids) {
            sqlBuilder.append("'" + id + "', ");
        }
        if (sqlBuilder.lastIndexOf(", ") != -1) {
            sqlBuilder.replace(sqlBuilder.length() - 2, sqlBuilder.length(), "");
        }
        sqlBuilder.append(")");
        return sqlBuilder.toString();
    }
}

