/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.query.param.impl;

import java.util.List;
import org.linuxprobe.crud.core.query.param.QueryParam;
import org.linuxprobe.crud.exception.OperationNotSupportedException;
import org.linuxprobe.crud.utils.SqlEscapeUtil;

public class StringParam
extends QueryParam {
    private String value;
    private String upperLimit;
    private String lowerLimit;
    private List<String> multipart;
    private Fuzzt fuzzt = Fuzzt.All;

    public StringParam(QueryParam.Operator operator) {
        if (operator != QueryParam.Operator.isNotNull && operator != QueryParam.Operator.isNull) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
    }

    public StringParam(QueryParam.Condition condition, QueryParam.Operator operator) {
        if (operator != QueryParam.Operator.isNotNull && operator != QueryParam.Operator.isNull) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.setCondition(condition);
    }

    public StringParam(String value) {
        this.value = value;
    }

    public StringParam(QueryParam.Condition condition, String value) {
        this.setCondition(condition);
        this.value = value;
    }

    public StringParam(QueryParam.Operator operator, String value) {
        if (operator == QueryParam.Operator.in || operator == QueryParam.Operator.notIn || operator == QueryParam.Operator.between || operator == QueryParam.Operator.notBetween) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.value = value;
    }

    public StringParam(QueryParam.Condition condition, QueryParam.Operator operator, String value) {
        if (operator == QueryParam.Operator.in || operator == QueryParam.Operator.notIn || operator == QueryParam.Operator.between || operator == QueryParam.Operator.notBetween) {
            throw new OperationNotSupportedException();
        }
        this.setCondition(condition);
        this.setOperator(operator);
        this.value = value;
    }

    public StringParam(QueryParam.Operator operator, Fuzzt fuzzt, String value) {
        if (operator != QueryParam.Operator.like && operator != QueryParam.Operator.unlike) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.fuzzt = fuzzt;
        this.value = value;
    }

    public StringParam(QueryParam.Condition condition, QueryParam.Operator operator, Fuzzt fuzzt, String value) {
        if (operator != QueryParam.Operator.like && operator != QueryParam.Operator.unlike) {
            throw new OperationNotSupportedException();
        }
        this.setCondition(condition);
        this.setOperator(operator);
        this.fuzzt = fuzzt;
        this.value = value;
    }

    public StringParam(QueryParam.Operator operator, String lowerLimit, String upperLimit) {
        if (operator != QueryParam.Operator.between && operator != QueryParam.Operator.notBetween) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    public StringParam(QueryParam.Condition condition, QueryParam.Operator operator, String lowerLimit, String upperLimit) {
        if (operator != QueryParam.Operator.between && operator != QueryParam.Operator.notBetween) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.setOperator(operator);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    public StringParam(QueryParam.Operator operator, List<String> multipart) {
        if (operator != QueryParam.Operator.in && operator != QueryParam.Operator.notIn) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.multipart = multipart;
    }

    public StringParam(QueryParam.Condition condition, QueryParam.Operator operator, List<String> multipart) {
        if (operator != QueryParam.Operator.in && operator != QueryParam.Operator.notIn) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.setOperator(operator);
        this.multipart = multipart;
    }

    @Override
    public String getValue() {
        String temp = this.value;
        if (temp == null) {
            return null;
        }
        temp = SqlEscapeUtil.escape(temp);
        if (this.getOperator() == QueryParam.Operator.like || this.getOperator() == QueryParam.Operator.unlike) {
            if (Fuzzt.All.equals((Object)this.fuzzt) || this.fuzzt == null) {
                return "'%" + temp + "%'";
            }
            if (Fuzzt.Right.equals((Object)this.fuzzt)) {
                return "'" + temp + "%'";
            }
            if (Fuzzt.Left.equals((Object)this.fuzzt)) {
                return "'%" + temp + "'";
            }
            return "'" + temp + "'";
        }
        return "'" + temp + "'";
    }

    @Override
    public String getMultipart() {
        if (this.multipart == null || this.multipart.isEmpty()) {
            return null;
        }
        StringBuffer valueBufffer = new StringBuffer();
        for (int i = 0; i < this.multipart.size(); ++i) {
            String tempvalue = this.multipart.get(i);
            tempvalue = SqlEscapeUtil.escape(tempvalue);
            if (i + 1 != this.multipart.size()) {
                valueBufffer.append("'" + tempvalue + "', ");
                continue;
            }
            valueBufffer.append("'" + tempvalue + "'");
        }
        return valueBufffer.toString();
    }

    @Override
    public String getUpperLimit() {
        String tempvalue = this.upperLimit;
        if (this.upperLimit == null) {
            return null;
        }
        tempvalue = SqlEscapeUtil.escape(tempvalue);
        return "'" + tempvalue + "'";
    }

    @Override
    public String getLowerLimit() {
        String tempvalue = this.lowerLimit;
        if (this.lowerLimit == null) {
            return null;
        }
        tempvalue = SqlEscapeUtil.escape(tempvalue);
        return "'" + tempvalue + "'";
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setUpperLimit(String upperLimit) {
        this.upperLimit = upperLimit;
    }

    public void setLowerLimit(String lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    public void setMultipart(List<String> multipart) {
        this.multipart = multipart;
    }

    public void setFuzzt(Fuzzt fuzzt) {
        this.fuzzt = fuzzt;
    }

    public StringParam() {
    }

    public static enum Fuzzt {
        Left,
        Right,
        All,
        Custom;

    }
}

