/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.query.param.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.linuxprobe.crud.core.query.param.QueryParam;
import org.linuxprobe.crud.exception.OperationNotSupportedException;

public class DateParam
extends QueryParam {
    private Date value;
    private Date upperLimit;
    private Date lowerLimit;
    private List<Date> multipart;
    private static final SimpleDateFormat dateForma = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public DateParam(QueryParam.Operator operator) {
        if (operator != QueryParam.Operator.isNotNull && operator != QueryParam.Operator.isNull) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
    }

    public DateParam(QueryParam.Condition condition, QueryParam.Operator operator) {
        if (operator != QueryParam.Operator.isNotNull && operator != QueryParam.Operator.isNull) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.setCondition(condition);
    }

    public DateParam(Date value) {
        this.value = value;
    }

    public DateParam(QueryParam.Condition condition, Date value) {
        this.setCondition(condition);
        this.value = value;
    }

    public DateParam(QueryParam.Operator operator, Date value) {
        if (operator == QueryParam.Operator.in || operator == QueryParam.Operator.notIn || operator == QueryParam.Operator.between || operator == QueryParam.Operator.notBetween) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.value = value;
    }

    public DateParam(QueryParam.Condition condition, QueryParam.Operator operator, Date value) {
        if (operator == QueryParam.Operator.in || operator == QueryParam.Operator.notIn || operator == QueryParam.Operator.between || operator == QueryParam.Operator.notBetween) {
            throw new OperationNotSupportedException();
        }
        this.setCondition(condition);
        this.setOperator(operator);
        this.value = value;
    }

    public DateParam(QueryParam.Operator operator, Date lowerLimit, Date upperLimit) {
        if (operator != QueryParam.Operator.between && operator != QueryParam.Operator.notBetween) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    public DateParam(QueryParam.Condition condition, QueryParam.Operator operator, Date lowerLimit, Date upperLimit) {
        if (operator != QueryParam.Operator.between && operator != QueryParam.Operator.notBetween) {
            throw new OperationNotSupportedException();
        }
        this.setCondition(condition);
        this.setOperator(operator);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    public DateParam(QueryParam.Operator operator, List<Date> multipart) {
        if (operator != QueryParam.Operator.in && operator != QueryParam.Operator.notIn) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.multipart = multipart;
    }

    public DateParam(QueryParam.Condition condition, QueryParam.Operator operator, List<Date> multipart) {
        if (operator != QueryParam.Operator.in && operator != QueryParam.Operator.notIn) {
            throw new OperationNotSupportedException();
        }
        this.setCondition(condition);
        this.setOperator(operator);
        this.multipart = multipart;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            return null;
        }
        String strValue = dateForma.format(this.value);
        if (this.getOperator() == QueryParam.Operator.like || this.getOperator() == QueryParam.Operator.unlike) {
            return "'%" + strValue + "%'";
        }
        return "'" + strValue + "'";
    }

    @Override
    public String getMultipart() {
        if (this.multipart == null || this.multipart.isEmpty()) {
            return null;
        }
        StringBuffer valueBufffer = new StringBuffer();
        for (int i = 0; i < this.multipart.size(); ++i) {
            Date tempvalue = this.multipart.get(i);
            String strTempvalue = dateForma.format(tempvalue);
            if (i + 1 != this.multipart.size()) {
                valueBufffer.append("'" + strTempvalue + "', ");
                continue;
            }
            valueBufffer.append("'" + strTempvalue + "'");
        }
        return valueBufffer.toString();
    }

    @Override
    public String getUpperLimit() {
        if (this.upperLimit == null) {
            return null;
        }
        String strUpperLimit = dateForma.format(this.upperLimit);
        return "'" + strUpperLimit + "'";
    }

    @Override
    public String getLowerLimit() {
        if (this.lowerLimit == null) {
            return null;
        }
        String strLowerLimit = dateForma.format(this.lowerLimit);
        return "'" + strLowerLimit + "'";
    }

    public void setValue(Date value) {
        this.value = value;
    }

    public void setUpperLimit(Date upperLimit) {
        this.upperLimit = upperLimit;
    }

    public void setLowerLimit(Date lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    public void setMultipart(List<Date> multipart) {
        this.multipart = multipart;
    }

    public DateParam() {
    }
}

