/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.query.param.impl;

import java.util.List;
import org.linuxprobe.crud.core.query.param.QueryParam;
import org.linuxprobe.crud.exception.OperationNotSupportedException;

public class BooleanParam
extends QueryParam {
    private Boolean value;
    private Boolean upperLimit;
    private Boolean lowerLimit;
    private List<Boolean> multipart;

    public BooleanParam(QueryParam.Operator operator) {
        if (operator != QueryParam.Operator.isNotNull && operator != QueryParam.Operator.isNull) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
    }

    public BooleanParam(QueryParam.Condition condition, QueryParam.Operator operator) {
        if (operator != QueryParam.Operator.isNotNull && operator != QueryParam.Operator.isNull) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.setCondition(condition);
    }

    public BooleanParam(Boolean value) {
        this.value = value;
    }

    public BooleanParam(QueryParam.Condition condition, Boolean value) {
        this.setCondition(condition);
        this.value = value;
    }

    public BooleanParam(QueryParam.Operator operator, Boolean value) {
        if (operator == QueryParam.Operator.in || operator == QueryParam.Operator.notIn || operator == QueryParam.Operator.between || operator == QueryParam.Operator.notBetween) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.value = value;
    }

    public BooleanParam(QueryParam.Condition condition, QueryParam.Operator operator, Boolean value) {
        if (operator == QueryParam.Operator.in || operator == QueryParam.Operator.notIn || operator == QueryParam.Operator.between || operator == QueryParam.Operator.notBetween) {
            throw new OperationNotSupportedException();
        }
        this.setCondition(condition);
        this.setOperator(operator);
        this.value = value;
    }

    public BooleanParam(QueryParam.Operator operator, Boolean lowerLimit, Boolean upperLimit) {
        if (operator != QueryParam.Operator.between && operator != QueryParam.Operator.notBetween) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    public BooleanParam(QueryParam.Condition condition, QueryParam.Operator operator, Boolean lowerLimit, Boolean upperLimit) {
        if (operator != QueryParam.Operator.between && operator != QueryParam.Operator.notBetween) {
            throw new OperationNotSupportedException();
        }
        this.setCondition(condition);
        this.setOperator(operator);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    public BooleanParam(QueryParam.Operator operator, List<Boolean> multipart) {
        if (operator != QueryParam.Operator.in && operator != QueryParam.Operator.notIn) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.multipart = multipart;
    }

    public BooleanParam(QueryParam.Condition condition, QueryParam.Operator operator, List<Boolean> multipart) {
        if (operator != QueryParam.Operator.in && operator != QueryParam.Operator.notIn) {
            throw new OperationNotSupportedException();
        }
        this.setCondition(condition);
        this.setOperator(operator);
        this.multipart = multipart;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value != false ? "1" : "0";
    }

    @Override
    public String getMultipart() {
        if (this.multipart == null || this.multipart.isEmpty()) {
            return null;
        }
        StringBuffer multipartValue = new StringBuffer();
        for (int i = 0; i < this.multipart.size(); ++i) {
            int tempvalue;
            int n = tempvalue = this.multipart.get(i) != false ? 1 : 0;
            if (i + 1 != this.multipart.size()) {
                multipartValue.append(tempvalue + ", ");
                continue;
            }
            multipartValue.append(tempvalue);
        }
        return multipartValue.toString();
    }

    @Override
    public String getUpperLimit() {
        if (this.upperLimit == null) {
            return null;
        }
        return this.upperLimit != false ? "1" : "0";
    }

    @Override
    public String getLowerLimit() {
        if (this.lowerLimit == null) {
            return null;
        }
        return this.lowerLimit != false ? "1" : "0";
    }

    public void setValue(Boolean value) {
        this.value = value;
    }

    public void setUpperLimit(Boolean upperLimit) {
        this.upperLimit = upperLimit;
    }

    public void setLowerLimit(Boolean lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    public void setMultipart(List<Boolean> multipart) {
        this.multipart = multipart;
    }

    public BooleanParam() {
    }
}

