/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.core.query;

import java.util.LinkedList;
import org.linuxprobe.crud.core.query.param.impl.StringParam;
import org.linuxprobe.crud.core.sql.generator.SelectSqlGenerator;

public abstract class BaseQuery {
    private Sqlr sqlr = new Sqlr();
    private String order;
    private StringParam id;
    private Limit limit = new Limit();
    private JoinType joinType = JoinType.LeftJoin;

    public void setOrder(String order) {
        if (order == null) {
            return;
        }
        if ((order = order.trim()).isEmpty()) {
            return;
        }
        String[] orders = order.split(",");
        StringBuilder result = new StringBuilder();
        if (orders != null) {
            for (int i = 0; i < orders.length; ++i) {
                String[] tempOrderMembers = orders[i].trim().split(" ");
                LinkedList<String> orderMembers = new LinkedList<String>();
                for (String tempOrderMember : tempOrderMembers) {
                    if (tempOrderMember.trim().isEmpty()) continue;
                    orderMembers.add(tempOrderMember);
                }
                if (orderMembers.size() > 2) {
                    throw new IllegalArgumentException("\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0ceg:\u5355\u5b57\u6bb5\u6392\u5e8f'name desc',\u591a\u5b57\u6bb5\u6392\u5e8f'name desc, code asc, email desc'");
                }
                if (orderMembers.size() == 1) {
                    result.append((String)orderMembers.get(0) + " ASC,");
                    continue;
                }
                if (orderMembers.size() != 2) continue;
                if (((String)orderMembers.get(1)).equalsIgnoreCase("asc")) {
                    result.append((String)orderMembers.get(0) + " ASC,");
                    continue;
                }
                if (((String)orderMembers.get(1)).equalsIgnoreCase("desc")) {
                    result.append((String)orderMembers.get(0) + " DESC,");
                    continue;
                }
                throw new IllegalArgumentException("\u6392\u5e8f\u6a21\u5f0f\u53ea\u80fd\u4e3aasc\u548cdesc");
            }
        }
        if (result.indexOf(",") != -1) {
            result.delete(result.length() - 1, result.length());
        }
        this.order = result.length() == 0 ? null : result.toString();
    }

    public Sqlr getSqlr() {
        return this.sqlr;
    }

    public String getOrder() {
        return this.order;
    }

    public StringParam getId() {
        return this.id;
    }

    public void setId(StringParam id) {
        this.id = id;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public void setJoinType(JoinType joinType) {
        this.joinType = joinType;
    }

    public static enum JoinType {
        LeftJoin,
        RightJoin,
        FullJoin,
        InnerJoin,
        CrossJoin;

    }

    public static class Limit {
        private int startRow = 0;
        private int currentPage = 1;
        private int pageSize = 10;

        private void init() {
            if (this.currentPage < 1) {
                this.currentPage = 1;
            }
            if (this.pageSize < 1) {
                this.pageSize = 10;
            }
            this.startRow = (this.currentPage - 1) * this.pageSize;
        }

        public Limit() {
        }

        public Limit(String currentPage, String pageSize) {
            this(Integer.parseInt(currentPage), Integer.parseInt(pageSize));
        }

        public Limit(int currentPage, int pageSize) {
            this.currentPage = currentPage;
            this.pageSize = pageSize;
            this.init();
        }

        public int getCurrentPage() {
            return this.currentPage;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public void setCurrentPage(int currentPage) {
            this.currentPage = currentPage;
            this.init();
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
            this.init();
        }

        public int getStartRow() {
            return this.startRow;
        }
    }

    public class Sqlr {
        public String toSelectSql() throws Exception {
            return SelectSqlGenerator.toSelectSql(BaseQuery.this);
        }

        public String toSelectCountSql() throws Exception {
            return SelectSqlGenerator.toSelectCountSql(BaseQuery.this);
        }

        public String toSelectCountSql(String clounm) throws Exception {
            return SelectSqlGenerator.toSelectCountSql(BaseQuery.this, clounm);
        }
    }
}

