/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.linuxprobe.crud.persistence.annotation.Column;
import org.linuxprobe.crud.utils.FieldUtils;
import org.linuxprobe.crud.utils.StringHumpTool;

public class EntityUtils {
    public static Field getFieldByColumnName(Class<?> entityClass, String columnName) {
        if (entityClass == null || columnName == null) {
            return null;
        }
        List<Field> fields = FieldUtils.getAllFields(entityClass);
        Field columnAnnotationMatch = null;
        Field nameMatch = null;
        Field lineToHumpMatch = null;
        for (Field field : fields) {
            Column column;
            if (field.getName().equals(columnName)) {
                nameMatch = field;
            }
            if (StringHumpTool.humpToLine2(field.getName(), "_").equals(columnName)) {
                lineToHumpMatch = field;
            }
            if (!field.isAnnotationPresent(Column.class) || (column = field.getAnnotation(Column.class)).value() == null || column.value().trim().isEmpty() || !column.value().trim().equals(columnName)) continue;
            columnAnnotationMatch = field;
        }
        if (columnAnnotationMatch != null) {
            return columnAnnotationMatch;
        }
        if (nameMatch != null) {
            return nameMatch;
        }
        if (lineToHumpMatch != null) {
            return lineToHumpMatch;
        }
        return null;
    }

    public static void setField(Object entity, String column, Object arg) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method methodOfSet;
        Field field = EntityUtils.getFieldByColumnName(entity.getClass(), column);
        if (field != null && (methodOfSet = FieldUtils.getMethodOfFieldSet(entity.getClass(), field)) != null) {
            Class<?> argType = methodOfSet.getParameterTypes()[0];
            if (arg == null || argType.isAssignableFrom(arg.getClass())) {
                methodOfSet.invoke(entity, arg);
            } else if (Boolean.class.isAssignableFrom(argType)) {
                String strArg = arg.toString();
                if (strArg.equals("0") || strArg.trim().isEmpty()) {
                    methodOfSet.invoke(entity, false);
                } else {
                    methodOfSet.invoke(entity, true);
                }
            } else if (Enum.class.isAssignableFrom(argType)) {
                Class<?> enumType = field.getType();
                if (Number.class.isAssignableFrom(arg.getClass())) {
                    Enum[] enums;
                    int ordinal = ((Number)arg).intValue();
                    for (Enum tempEnum : enums = (Enum[])enumType.getEnumConstants()) {
                        if (tempEnum.ordinal() != ordinal) continue;
                        methodOfSet.invoke(entity, tempEnum);
                        break;
                    }
                } else if (String.class.isAssignableFrom(arg.getClass())) {
                    methodOfSet.invoke(entity, Enum.valueOf(enumType, (String)arg));
                }
            }
        }
    }
}

