/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.persistence;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.linuxprobe.crud.exception.OperationNotSupportedException;
import org.linuxprobe.crud.exception.ParameterException;
import org.linuxprobe.crud.exception.UnknownTableException;
import org.linuxprobe.crud.persistence.annotation.Column;
import org.linuxprobe.crud.persistence.annotation.PrimaryKey;
import org.linuxprobe.crud.persistence.annotation.Table;
import org.linuxprobe.crud.persistence.annotation.Transient;
import org.linuxprobe.crud.utils.FieldUtils;
import org.linuxprobe.crud.utils.SqlEscapeUtil;
import org.linuxprobe.crud.utils.StringHumpTool;

public class Sqlr {
    private static volatile Sqlr instance = new Sqlr();
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private Sqlr() {
    }

    public static Sqlr getInstance() {
        return instance;
    }

    public static String toInsertSql(Object entity) {
        String table = Sqlr.getTable(entity);
        if (table == null) {
            throw new UnknownTableException("\u8bf7\u5728\u5b9e\u4f53\u7c7b\u4e0a\u6807\u6ce8\u6ce8\u89e3@Table(\"table\")");
        }
        StringBuffer sqlBuffer = new StringBuffer("insert into " + table + " ");
        StringBuffer clounms = new StringBuffer("(");
        StringBuffer values = new StringBuffer(" values(");
        List<Field> attributes = Sqlr.getAttributes(entity, true);
        if (attributes.isEmpty()) {
            throw new OperationNotSupportedException("\u8be5\u5b9e\u4f53\u7c7b\u6ca1\u6709\u4efb\u4f55\u5b57\u6bb5");
        }
        for (int i = 0; i < attributes.size(); ++i) {
            Field attribute = attributes.get(i);
            if (i + 1 == attributes.size()) {
                clounms.append(attribute.getColumn() + ")");
                values.append(attribute.getValue() + ")");
                continue;
            }
            clounms.append(attribute.getColumn() + ", ");
            values.append(attribute.getValue() + ", ");
        }
        sqlBuffer.append(clounms);
        sqlBuffer.append(values);
        return sqlBuffer.toString();
    }

    public static String toBatchInsertSql(List<Object> entitys) {
        if (entitys == null || entitys.isEmpty()) {
            throw new OperationNotSupportedException("\u6ca1\u6709\u9700\u8981\u88ab\u4fdd\u5b58\u7684\u5b9e\u4f53");
        }
        StringBuffer sqlBuffer = new StringBuffer();
        for (int i = 0; i < entitys.size(); ++i) {
            Object entity = entitys.get(i);
            if (i == 0) {
                sqlBuffer.append(Sqlr.toInsertSql(entity));
                continue;
            }
            String sql = Sqlr.toInsertSql(entity);
            String sqlValue = sql.substring(sql.indexOf("values") + 6);
            sqlBuffer.append(", " + sqlValue);
        }
        return sqlBuffer.toString();
    }

    public static String toDeleteSql(Object entity) {
        if (entity == null) {
            throw new OperationNotSupportedException("\u6ca1\u6709\u9700\u8981\u88ab\u5220\u9664\u7684\u5b9e\u4f53");
        }
        List<Field> attributes = Sqlr.getAttributes(entity, false);
        Field primaryKey = Sqlr.getPrimaryKey(attributes);
        String table = Sqlr.getTable(entity);
        if (table == null) {
            throw new UnknownTableException("\u8bf7\u5728\u5b9e\u4f53\u7c7b\u4e0a\u6807\u6ce8\u6ce8\u89e3@Table(\"table\")");
        }
        String sql = "delete from " + table + " where " + primaryKey.getColumn() + " = " + primaryKey.getValue();
        return sql;
    }

    public static String toDeleteSqlByPrimaryKey(String id, Class<?> type) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (id == null) {
            throw new OperationNotSupportedException("\u6ca1\u6709\u9700\u8981\u88ab\u5220\u9664\u7684\u5b9e\u4f53");
        }
        Object entity = type.getConstructor(new Class[0]).newInstance(new Object[0]);
        List<Field> attributes = Sqlr.getAttributes(entity, true);
        Field primaryKey = Sqlr.getPrimaryKey(attributes);
        String table = Sqlr.getTable(entity);
        if (table == null) {
            throw new UnknownTableException("\u8bf7\u5728\u5b9e\u4f53\u7c7b\u4e0a\u6807\u6ce8\u6ce8\u89e3@Table(\"table\")");
        }
        String sql = "delete from " + table + " where " + primaryKey.getColumn() + " = '" + id + "'";
        return sql;
    }

    public static String toBatchDeleteSql(List<Object> entitys) {
        if (entitys == null || entitys.isEmpty()) {
            throw new OperationNotSupportedException("\u6ca1\u6709\u9700\u8981\u88ab\u5220\u9664\u7684\u5b9e\u4f53");
        }
        StringBuffer sqlBuffer = new StringBuffer("delete from ");
        for (int i = 0; i < entitys.size(); ++i) {
            Object entity = entitys.get(i);
            List<Field> attributes = Sqlr.getAttributes(entity, false);
            Field primaryKey = Sqlr.getPrimaryKey(attributes);
            if (i == 0) {
                String table = Sqlr.getTable(entity);
                if (table == null) {
                    throw new UnknownTableException("\u8bf7\u5728\u5b9e\u4f53\u7c7b\u4e0a\u6807\u6ce8\u6ce8\u89e3@Table(\"table\")");
                }
                sqlBuffer.append(table + " where " + primaryKey.getColumn() + " in(");
            }
            sqlBuffer.append(primaryKey.getValue() + ", ");
        }
        if (sqlBuffer.lastIndexOf(", ") != -1) {
            sqlBuffer.replace(sqlBuffer.length() - 2, sqlBuffer.length(), "");
        }
        sqlBuffer.append(")");
        return sqlBuffer.toString();
    }

    public static String toBatchDeleteSqlByPrimaryKey(List<String> ids, Class<?> type) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (ids == null || ids.isEmpty()) {
            throw new OperationNotSupportedException("\u6ca1\u6709\u9700\u8981\u88ab\u5220\u9664\u7684\u5b9e\u4f53");
        }
        Object entity = type.getConstructor(new Class[0]).newInstance(new Object[0]);
        List<Field> attributes = Sqlr.getAttributes(entity, true);
        Field primaryKey = Sqlr.getPrimaryKey(attributes);
        String table = Sqlr.getTable(entity);
        if (table == null) {
            throw new UnknownTableException("\u8bf7\u5728\u5b9e\u4f53\u7c7b\u4e0a\u6807\u6ce8\u6ce8\u89e3@Table(\"table\")");
        }
        StringBuffer sqlBuffer = new StringBuffer("delete from " + table + " where " + primaryKey.getColumn() + " in (");
        for (String id : ids) {
            sqlBuffer.append("'" + id + "', ");
        }
        if (sqlBuffer.lastIndexOf(", ") != -1) {
            sqlBuffer.replace(sqlBuffer.length() - 2, sqlBuffer.length(), "");
        }
        sqlBuffer.append(")");
        return sqlBuffer.toString();
    }

    public static String toGlobalUpdateSql(Object entity) {
        String table = Sqlr.getTable(entity);
        if (table == null) {
            throw new UnknownTableException("\u8bf7\u5728\u5b9e\u4f53\u7c7b\u4e0a\u6807\u6ce8\u6ce8\u89e3@Table(\"table\")");
        }
        StringBuffer sqlBuffer = new StringBuffer("update " + table + " set ");
        List<Field> attributes = Sqlr.getAttributes(entity, false);
        Field primaryKey = Sqlr.getPrimaryKey(attributes);
        if (primaryKey == null) {
            throw new OperationNotSupportedException("\u8bf7\u4f7f\u7528@PrimaryKey\u6307\u5b9a\u4e3b\u952e");
        }
        attributes.remove(primaryKey);
        for (int i = 0; i < attributes.size(); ++i) {
            Field attribute = attributes.get(i);
            if (attribute.getColumn().equals("create_time") || attribute.getColumn().equals("creater_id")) continue;
            sqlBuffer.append(attribute.getColumn() + " = " + attribute.getValue() + ", ");
        }
        if (sqlBuffer.indexOf(",") != -1) {
            sqlBuffer.replace(sqlBuffer.length() - 2, sqlBuffer.length(), " ");
        }
        sqlBuffer.append("where " + primaryKey.getColumn() + " = " + primaryKey.getValue());
        return sqlBuffer.toString();
    }

    public static String toLocalUpdateSql(Object entity) {
        String table = Sqlr.getTable(entity);
        if (table == null) {
            throw new UnknownTableException("\u8bf7\u5728\u5b9e\u4f53\u7c7b\u4e0a\u6807\u6ce8\u6ce8\u89e3@Table(\"table\")");
        }
        StringBuffer sqlBuffer = new StringBuffer("update " + table + " set ");
        List<Field> attributes = Sqlr.getAttributes(entity, false);
        Field primaryKey = Sqlr.getPrimaryKey(attributes);
        if (primaryKey == null) {
            throw new OperationNotSupportedException("\u8bf7\u4f7f\u7528@PrimaryKey\u6307\u5b9a\u4e3b\u952e");
        }
        attributes.remove(primaryKey);
        for (int i = 0; i < attributes.size(); ++i) {
            Field attribute = attributes.get(i);
            if (attribute.getValue() == null) continue;
            sqlBuffer.append(attribute.getColumn() + " = " + attribute.getValue() + ", ");
        }
        if (sqlBuffer.indexOf(",") != -1) {
            sqlBuffer.replace(sqlBuffer.length() - 2, sqlBuffer.length(), " ");
        } else {
            sqlBuffer.append(primaryKey.getColumn() + " = " + primaryKey.getValue() + " ");
        }
        sqlBuffer.append("where " + primaryKey.getColumn() + " = " + primaryKey.getValue());
        return sqlBuffer.toString();
    }

    private static <T> String getTable(T entity) {
        Class<?> entityClass = entity.getClass();
        boolean classHasTableAnno = entityClass.isAnnotationPresent(Table.class);
        if (classHasTableAnno) {
            Table annotation = entityClass.getAnnotation(Table.class);
            String table = annotation.value();
            return table.isEmpty() ? null : table;
        }
        return null;
    }

    private static List<Field> getAttributes(Object entity, boolean isInsertMode) {
        LinkedList<Field> result = new LinkedList<Field>();
        List<java.lang.reflect.Field> fields = FieldUtils.getAllFields(entity.getClass());
        for (int i = 0; i < fields.size(); ++i) {
            Column column;
            java.lang.reflect.Field field = fields.get(i);
            Field myField = new Field();
            String fieldName = field.getName();
            myField.setName(fieldName);
            boolean needAppend = true;
            String funSuffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Method getCurrnetClounm = null;
            try {
                getCurrnetClounm = entity.getClass().getMethod("get" + funSuffix, new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                continue;
            }
            String value = null;
            Object fieldValue = null;
            try {
                fieldValue = getCurrnetClounm.invoke(entity, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                continue;
            }
            if (String.class.isAssignableFrom(field.getType())) {
                String clounmValue = (String)fieldValue;
                if (clounmValue != null) {
                    if (field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)).length() > 0 && clounmValue.length() > column.length()) {
                        if (column.lengthHandler().equals((Object)Column.LengthHandler.Sub)) {
                            clounmValue = clounmValue.substring(0, column.length());
                        } else {
                            throw new ParameterException(field.getName() + "\u5b57\u6bb5\u7684\u8d4b\u503c\u8d85\u51fa\u89c4\u5b9a\u957f\u5ea6" + column.length());
                        }
                    }
                    clounmValue = SqlEscapeUtil.escape(clounmValue);
                    value = "'" + clounmValue + "'";
                } else {
                    value = null;
                }
            } else if (Number.class.isAssignableFrom(field.getType())) {
                Number clounmValue = (Number)fieldValue;
                value = clounmValue != null ? clounmValue.toString() : null;
            } else if (Boolean.class.isAssignableFrom(field.getType())) {
                Boolean clounmValue = (Boolean)fieldValue;
                value = clounmValue != null ? (clounmValue.booleanValue() ? "1" : "0") : null;
            } else if (Date.class.isAssignableFrom(field.getType())) {
                Date clounmValue = (Date)fieldValue;
                value = clounmValue != null ? "'" + dateFormat.format(clounmValue) + "'" : null;
            } else if (Enum.class.isAssignableFrom(field.getType())) {
                Enum clounmValue = (Enum)fieldValue;
                if (clounmValue != null) {
                    value = clounmValue.ordinal() + "";
                    if (field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)).enumHandler().equals((Object)Column.EnumHandler.Name)) {
                        value = "'" + clounmValue.toString() + "'";
                    }
                } else {
                    value = null;
                }
            } else {
                needAppend = false;
            }
            if (!needAppend || field.isAnnotationPresent(Transient.class)) continue;
            boolean isPrimaryKey = false;
            myField.setColumn(StringHumpTool.humpToLine2(fieldName, "_"));
            if (field.isAnnotationPresent(PrimaryKey.class)) {
                isPrimaryKey = true;
                if (value == null && isInsertMode) {
                    PrimaryKey primaryKey = field.getAnnotation(PrimaryKey.class);
                    if (primaryKey.value().equals((Object)PrimaryKey.Strategy.UUID)) {
                        try {
                            String uuid = UUID.randomUUID().toString();
                            Method setFun = entity.getClass().getMethod("set" + funSuffix, String.class);
                            setFun.invoke(entity, uuid);
                            value = "'" + uuid + "'";
                        }
                        catch (Exception e) {
                            throw new OperationNotSupportedException("\u672a\u627e\u5230\u4e3b\u952e\u7684set\u65b9\u6cd5");
                        }
                    } else if (primaryKey.value().equals((Object)PrimaryKey.Strategy.ASSIGNED)) {
                        throw new NullPointerException("\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                } else if (value == null && !isInsertMode) {
                    throw new NullPointerException("\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (field.isAnnotationPresent(Column.class)) {
                column = field.getAnnotation(Column.class);
                if (column.updateIgnore() && !isInsertMode) continue;
                String strColumn = column.value();
                if (strColumn != null && !strColumn.trim().isEmpty()) {
                    myField.setColumn(strColumn);
                }
            }
            myField.setIsPrimaryKey(isPrimaryKey);
            myField.setValue(value);
            result.add(myField);
        }
        return result;
    }

    private static Field getPrimaryKey(List<Field> attributes) {
        for (Field attribute : attributes) {
            if (!attribute.isPrimaryKey.booleanValue()) continue;
            return attribute;
        }
        return null;
    }

    public static class Field {
        private String column;
        private String name;
        private String value;
        Boolean isPrimaryKey;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.column == null ? 0 : this.column.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Field other = (Field)obj;
            return !(this.column == null ? other.column != null : !this.column.equals(other.column));
        }

        public String getColumn() {
            return this.column;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public Boolean getIsPrimaryKey() {
            return this.isPrimaryKey;
        }

        public void setColumn(String column) {
            this.column = column;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setIsPrimaryKey(Boolean isPrimaryKey) {
            this.isPrimaryKey = isPrimaryKey;
        }
    }
}

