/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.query.param.impl;

import java.util.List;
import org.linuxprobe.crud.exception.OperationNotSupportedException;
import org.linuxprobe.crud.query.param.QueryParam;

public class StringParam
extends QueryParam {
    private String value;
    private String upperLimit;
    private String lowerLimit;
    private List<String> multipart;

    public StringParam(String value) {
        this.value = value;
    }

    public StringParam(QueryParam.Condition condition, String value) {
        this.setCondition(condition);
        this.value = value;
    }

    public StringParam(QueryParam.Operator operator, String value) {
        if (operator == QueryParam.Operator.in || operator == QueryParam.Operator.notIn || operator == QueryParam.Operator.between || operator == QueryParam.Operator.notBetween) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.value = value;
    }

    public StringParam(QueryParam.Condition condition, QueryParam.Operator operator, String value) {
        if (operator == QueryParam.Operator.in || operator == QueryParam.Operator.notIn || operator == QueryParam.Operator.between || operator == QueryParam.Operator.notBetween) {
            throw new OperationNotSupportedException();
        }
        this.setCondition(condition);
        this.setOperator(operator);
        this.value = value;
    }

    public StringParam(QueryParam.Operator operator, String lowerLimit, String upperLimit) {
        if (operator != QueryParam.Operator.between && operator != QueryParam.Operator.notBetween) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    public StringParam(QueryParam.Condition condition, QueryParam.Operator operator, String lowerLimit, String upperLimit) {
        if (operator != QueryParam.Operator.between && operator != QueryParam.Operator.notBetween) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.setOperator(operator);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    public StringParam(QueryParam.Operator operator, List<String> multipart) {
        if (operator != QueryParam.Operator.in && operator != QueryParam.Operator.notIn) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.multipart = multipart;
    }

    public StringParam(QueryParam.Condition condition, QueryParam.Operator operator, List<String> multipart) {
        if (operator != QueryParam.Operator.in && operator != QueryParam.Operator.notIn) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.setOperator(operator);
        this.multipart = multipart;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            return null;
        }
        if (this.getOperator() == QueryParam.Operator.like || this.getOperator() == QueryParam.Operator.unlike) {
            return "'%" + this.value + "%'";
        }
        return "'" + this.value + "'";
    }

    @Override
    public String getMultipart() {
        if (this.multipart == null || this.multipart.isEmpty()) {
            return null;
        }
        StringBuffer valueBufffer = new StringBuffer();
        for (int i = 0; i < this.multipart.size(); ++i) {
            String tempvalue = this.multipart.get(i);
            if (i + 1 != this.multipart.size()) {
                valueBufffer.append("'" + tempvalue + "', ");
                continue;
            }
            valueBufffer.append("'" + tempvalue + "'");
        }
        return valueBufffer.toString();
    }

    @Override
    public String getUpperLimit() {
        if (this.upperLimit == null) {
            return null;
        }
        return "'" + this.upperLimit + "'";
    }

    @Override
    public String getLowerLimit() {
        if (this.lowerLimit == null) {
            return null;
        }
        return "'" + this.lowerLimit + "'";
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setUpperLimit(String upperLimit) {
        this.upperLimit = upperLimit;
    }

    public void setLowerLimit(String lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    public void setMultipart(List<String> multipart) {
        this.multipart = multipart;
    }

    public StringParam() {
    }
}

