/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.query.param.impl;

import java.util.List;
import org.linuxprobe.crud.exception.OperationNotSupportedException;
import org.linuxprobe.crud.exception.ParameterException;
import org.linuxprobe.crud.query.param.QueryParam;

public class NumberParam
extends QueryParam {
    private Number value;
    private Number upperLimit;
    private Number lowerLimit;
    private List<Number> multipart;

    public NumberParam(Number value) {
        this.value = value;
    }

    public NumberParam(QueryParam.Condition condition, Number value) {
        this.setCondition(condition);
        this.value = value;
    }

    public NumberParam(QueryParam.Operator operator, Number value) {
        if (operator == QueryParam.Operator.in || operator == QueryParam.Operator.notIn || operator == QueryParam.Operator.between || operator == QueryParam.Operator.notBetween) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.value = value;
    }

    public NumberParam(QueryParam.Condition condition, QueryParam.Operator operator, Number value) {
        if (operator == QueryParam.Operator.in || operator == QueryParam.Operator.notIn || operator == QueryParam.Operator.between || operator == QueryParam.Operator.notBetween) {
            throw new OperationNotSupportedException();
        }
        this.setCondition(condition);
        this.setOperator(operator);
        this.value = value;
    }

    public NumberParam(QueryParam.Operator operator, Number lowerLimit, Number upperLimit) {
        if (operator != QueryParam.Operator.between && operator != QueryParam.Operator.notBetween) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    public NumberParam(QueryParam.Condition condition, QueryParam.Operator operator, Number lowerLimit, Number upperLimit) {
        if (operator != QueryParam.Operator.between && operator != QueryParam.Operator.notBetween) {
            throw new OperationNotSupportedException();
        }
        this.setCondition(condition);
        this.setOperator(operator);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    public NumberParam(QueryParam.Operator operator, List<Number> multipart) {
        if (operator != QueryParam.Operator.in && operator != QueryParam.Operator.notIn) {
            throw new OperationNotSupportedException();
        }
        this.setOperator(operator);
        this.multipart = multipart;
    }

    public NumberParam(QueryParam.Condition condition, QueryParam.Operator operator, List<Number> multipart) {
        if (operator != QueryParam.Operator.in && operator != QueryParam.Operator.notIn) {
            throw new OperationNotSupportedException();
        }
        this.setCondition(condition);
        this.setOperator(operator);
        this.multipart = multipart;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    @Override
    public String getUpperLimit() {
        if (this.upperLimit == null) {
            return null;
        }
        return this.upperLimit.toString();
    }

    @Override
    public String getLowerLimit() {
        if (this.lowerLimit == null) {
            return null;
        }
        return this.lowerLimit.toString();
    }

    @Override
    public String getMultipart() {
        if (this.multipart == null || this.multipart.isEmpty()) {
            return null;
        }
        StringBuffer multipartValue = new StringBuffer();
        for (int i = 0; i < this.multipart.size(); ++i) {
            Number tempvalue = this.multipart.get(i);
            if (i + 1 != this.multipart.size()) {
                multipartValue.append(tempvalue.toString() + ", ");
                continue;
            }
            multipartValue.append(tempvalue.toString());
        }
        return multipartValue.toString();
    }

    @Override
    public void setOperator(QueryParam.Operator operator) {
        if (operator == QueryParam.Operator.like || operator == QueryParam.Operator.unlike || this.getOperator() == QueryParam.Operator.regexp) {
            throw new ParameterException("\u6570\u5b57\u7c7b\u578b\u4e0d\u652f\u6301like nunlike regexp\u67e5\u8be2");
        }
        super.setOperator(operator);
    }

    public void setValue(Number value) {
        this.value = value;
    }

    public void setUpperLimit(Number upperLimit) {
        this.upperLimit = upperLimit;
    }

    public void setLowerLimit(Number lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    public void setMultipart(List<Number> multipart) {
        this.multipart = multipart;
    }

    public NumberParam() {
    }
}

