/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.query.param;

public abstract class QueryParam {
    private Operator operator = Operator.equal;
    private Condition condition = Condition.and;

    public String toSqlPart() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.operator == Operator.equal || this.operator == Operator.unequal || this.operator == Operator.greaterThan || this.operator == Operator.lessThan || this.operator == Operator.greaterThanOrEqualTo || this.operator == Operator.lessThanOrEqualTo || this.operator == Operator.regexp || this.operator == Operator.like || this.operator == Operator.unlike) {
            return this.operator.getOperator() + " " + this.getValue();
        }
        if (this.operator == Operator.between || this.operator == Operator.notBetween) {
            return this.operator.getOperator() + " " + this.getLowerLimit() + " and " + this.getUpperLimit();
        }
        if (this.operator == Operator.in || this.operator == Operator.notIn) {
            return this.operator.getOperator() + "(" + this.getMultipart() + ")";
        }
        if (this.operator == Operator.isNull || this.operator == Operator.isNotNull) {
            return this.operator.getOperator() + " null";
        }
        return null;
    }

    public boolean isEmpty() {
        if (this.getOperator() == Operator.isNull || this.getOperator() == Operator.isNotNull) {
            return false;
        }
        if (this.getOperator() == Operator.between || this.getOperator() == Operator.notBetween) {
            return this.getUpperLimit() == null || this.getLowerLimit() == null;
        }
        if (this.getOperator() == Operator.in || this.getOperator() == Operator.notIn) {
            return this.getMultipart() == null;
        }
        return this.getValue() == null;
    }

    public abstract String getValue();

    public abstract String getMultipart();

    public abstract String getUpperLimit();

    public abstract String getLowerLimit();

    public void setOperator(Operator operator) {
        this.operator = operator == null ? Operator.equal : operator;
    }

    public void setCondition(Condition condition) {
        this.condition = condition == null ? Condition.and : condition;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public static class Condition {
        private String condition;
        public static final Condition and = new Condition("and");
        public static final Condition or = new Condition("or");

        private Condition(String condition) {
            this.condition = condition;
        }

        public String toString() {
            return this.condition;
        }

        public String getCondition() {
            return this.condition;
        }
    }

    public static class Operator {
        private String operator = "=";
        public static final Operator equal = new Operator("=");
        public static final Operator unequal = new Operator("!=");
        public static final Operator greaterThan = new Operator(">");
        public static final Operator lessThan = new Operator("<");
        public static final Operator greaterThanOrEqualTo = new Operator(">=");
        public static final Operator lessThanOrEqualTo = new Operator("<=");
        public static final Operator between = new Operator("between");
        public static final Operator notBetween = new Operator("not between");
        public static final Operator in = new Operator("in");
        public static final Operator notIn = new Operator("not in");
        public static final Operator like = new Operator("like");
        public static final Operator unlike = new Operator("not like");
        public static final Operator isNull = new Operator("is");
        public static final Operator isNotNull = new Operator("is not");
        public static final Operator regexp = new Operator("regexp");

        private Operator(String operator) {
            this.operator = operator;
        }

        public String getOperator() {
            return this.operator;
        }
    }
}

