/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.query;

import org.linuxprobe.crud.exception.ParameterException;
import org.linuxprobe.crud.persistence.SelectSqler;
import org.linuxprobe.crud.query.param.impl.StringParam;
import org.linuxprobe.crud.utils.StringHumpTool;

public abstract class BaseQuery {
    private Sqlr sqlr = new Sqlr();
    private String order;
    private StringParam id;
    private Limit limit = new Limit();

    public void setOrder(String order) {
        String[] orders = order.split(",");
        StringBuffer result = new StringBuffer();
        if (orders != null) {
            for (int i = 0; i < orders.length; ++i) {
                String[] orderMembers = orders[i].trim().split(" ");
                if (orderMembers.length > 2) {
                    orderMembers[1] = orderMembers[orderMembers.length - 1];
                }
                if (orderMembers == null || orderMembers.length <= 0) continue;
                String[] members = new String[2];
                members[0] = StringHumpTool.humpToLine2(orderMembers[0], "_");
                if (orderMembers.length == 1) {
                    members[1] = "asc";
                } else if (orderMembers[1].equalsIgnoreCase("asc")) {
                    members[1] = "asc";
                } else if (orderMembers[1].equalsIgnoreCase("desc")) {
                    members[1] = "desc";
                } else {
                    throw new ParameterException("\u6392\u5e8f\u6a21\u5f0f\u53ea\u80fd\u4e3aasc\u548cdesc");
                }
                if (i + 1 == orders.length) {
                    result.append(members[0] + " " + members[1]);
                    continue;
                }
                result.append(members[0] + " " + members[1] + ",");
            }
        }
        this.order = result.toString();
    }

    public Sqlr getSqlr() {
        return this.sqlr;
    }

    public String getOrder() {
        return this.order;
    }

    public StringParam getId() {
        return this.id;
    }

    public void setId(StringParam id) {
        this.id = id;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public static class Limit {
        private int startRow;
        private int size;
        private int currentPage = 1;
        private int pageSize = 10;

        private void init() {
            if (this.currentPage < 1) {
                this.currentPage = 1;
            }
            if (this.pageSize < 1) {
                this.pageSize = 10;
            }
            this.startRow = (this.currentPage - 1) * this.pageSize;
            this.size = this.pageSize;
        }

        public Limit() {
        }

        public Limit(String currentPage, String pageSize) {
            this(Integer.parseInt(currentPage), Integer.parseInt(pageSize));
        }

        public Limit(int currentPage, int pageSize) {
            this.currentPage = currentPage;
            this.pageSize = pageSize;
            this.init();
        }

        public String toLimit() {
            this.init();
            return this.startRow + ", " + this.size;
        }

        public int getCurrentPage() {
            this.init();
            return this.currentPage;
        }

        public int getPageSize() {
            this.init();
            return this.pageSize;
        }

        public void setCurrentPage(int currentPage) {
            this.currentPage = currentPage;
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }
    }

    public class Sqlr {
        public String toSelectSql() throws Exception {
            return SelectSqler.toSelectSql(BaseQuery.this);
        }

        public String toSelectCountSql() throws Exception {
            return SelectSqler.toSelectCountSql(BaseQuery.this);
        }

        public String toSelectCountSql(String clounm) throws Exception {
            return SelectSqler.toSelectCountSql(BaseQuery.this, clounm);
        }
    }
}

