/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.crud.persistence;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.linuxprobe.crud.exception.OperationNotSupportedException;
import org.linuxprobe.crud.persistence.AliasGenerate;
import org.linuxprobe.crud.persistence.annotation.Column;
import org.linuxprobe.crud.persistence.annotation.PrimaryKey;
import org.linuxprobe.crud.persistence.annotation.Search;
import org.linuxprobe.crud.persistence.annotation.Table;
import org.linuxprobe.crud.query.BaseQuery;
import org.linuxprobe.crud.query.param.QueryParam;
import org.linuxprobe.crud.utils.StringHumpTool;

public class SelectSqler {
    private static ThreadLocal<Map<Object, String>> alias = new ThreadLocal();

    private static Map<Object, String> getAlias() {
        Map<Object, String> result = alias.get();
        if (result == null) {
            alias.set(new HashMap());
            result = alias.get();
        }
        return result;
    }

    private static String getAlias(Object key) {
        Map<Object, String> alias = SelectSqler.getAlias();
        String result = alias.get(key);
        if (result == null) {
            alias.put(key, AliasGenerate.getAlias());
            result = alias.get(key);
        }
        return result;
    }

    public static String toSelectSql(Object searcher) {
        String alias = SelectSqler.getAlias(searcher);
        StringBuffer sqlBuffer = new StringBuffer("select distinct " + alias + ".* from " + SelectSqler.getTable(searcher.getClass()) + " as " + alias + " ");
        sqlBuffer.append(SelectSqler.toLeftJoin(searcher));
        sqlBuffer.append("where " + SelectSqler.getFormatWhere(searcher));
        sqlBuffer.append(SelectSqler.toOrder(searcher));
        sqlBuffer.append(SelectSqler.toLimit(searcher));
        return sqlBuffer.toString();
    }

    public static String toSelectCountSql(Object searcher, String clounm) {
        String countFun = "count(distinct " + SelectSqler.getAlias(searcher) + "." + clounm + ")";
        StringBuffer sqlBuffer = new StringBuffer("select " + countFun + " from " + SelectSqler.getTable(searcher.getClass()) + " as " + SelectSqler.getAlias(searcher) + " ");
        sqlBuffer.append(SelectSqler.toLeftJoin(searcher));
        sqlBuffer.append("where " + SelectSqler.getFormatWhere(searcher));
        return sqlBuffer.toString();
    }

    public static String toSelectCountSql(Object searcher) {
        String countFun = "count(distinct " + SelectSqler.getAlias(searcher) + "." + SelectSqler.getPrimaryKeyName(SelectSqler.getModelType(searcher.getClass())) + ")";
        StringBuffer sqlBuffer = new StringBuffer("select " + countFun + " from " + SelectSqler.getTable(searcher.getClass()) + " as " + SelectSqler.getAlias(searcher) + " ");
        sqlBuffer.append(SelectSqler.toLeftJoin(searcher));
        sqlBuffer.append("where " + SelectSqler.getFormatWhere(searcher));
        return sqlBuffer.toString();
    }

    private static StringBuffer toLeftJoin(Object searcher) {
        List<Field> fields = Arrays.asList(searcher.getClass().getDeclaredFields());
        fields = new ArrayList<Field>(fields);
        Class<?> superClass = searcher.getClass().getSuperclass();
        if (superClass != null) {
            while (!superClass.equals(Object.class)) {
                fields.addAll(Arrays.asList(superClass.getDeclaredFields()));
                superClass = superClass.getSuperclass();
            }
        }
        StringBuffer joinBuffer = new StringBuffer();
        for (Field field : fields) {
            Column column;
            if (!field.getType().isAnnotationPresent(Search.class)) continue;
            String fieldName = field.getName();
            String funSuffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Method getCurrnetParam = null;
            try {
                getCurrnetParam = searcher.getClass().getMethod("get" + funSuffix, new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                continue;
            }
            Object member = null;
            try {
                member = getCurrnetParam.invoke(searcher, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                continue;
            }
            if (member == null) continue;
            String columnName = StringHumpTool.humpToLine2(fieldName + "Id", "_");
            if (field.isAnnotationPresent(Column.class) && !(column = field.getAnnotation(Column.class)).value().trim().isEmpty()) {
                columnName = column.value();
            }
            String joinTable = SelectSqler.getTable(field.getType());
            String joinTableAlias = SelectSqler.getAlias(member);
            joinBuffer.append("left join " + joinTable + " as " + joinTableAlias + " on ");
            joinBuffer.append(joinTableAlias + "." + SelectSqler.getPrimaryKeyName(SelectSqler.getModelType(field.getType())) + " = ");
            joinBuffer.append(SelectSqler.getAlias(searcher) + "." + columnName + " ");
            joinBuffer.append(SelectSqler.toLeftJoin(member));
        }
        return joinBuffer;
    }

    private static String toOrder(Object searcher) {
        BaseQuery baseQuery;
        if (BaseQuery.class.isAssignableFrom(searcher.getClass()) && (baseQuery = (BaseQuery)searcher).getOrder() != null) {
            return " order by " + baseQuery.getOrder() + " ";
        }
        return "";
    }

    private static String toLimit(Object searcher) {
        BaseQuery baseQuery;
        if (BaseQuery.class.isAssignableFrom(searcher.getClass()) && (baseQuery = (BaseQuery)searcher).getLimit() != null) {
            return "limit " + baseQuery.getLimit().toLimit() + " ";
        }
        return "";
    }

    private static LinkedList<String> toWhere(Object searcher) {
        List<Field> fields = Arrays.asList(searcher.getClass().getDeclaredFields());
        fields = new ArrayList<Field>(fields);
        Class<?> superClass = searcher.getClass().getSuperclass();
        if (superClass != null) {
            while (!superClass.equals(Object.class)) {
                fields.addAll(Arrays.asList(superClass.getDeclaredFields()));
                superClass = superClass.getSuperclass();
            }
        }
        LinkedList<String> result = new LinkedList<String>();
        for (Field field : fields) {
            Column column;
            String fieldName = field.getName();
            String columnName = StringHumpTool.humpToLine2(fieldName, "_");
            if (field.isAnnotationPresent(Column.class) && !(column = field.getAnnotation(Column.class)).value().trim().isEmpty()) {
                columnName = column.value();
            }
            String funSuffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Method getCurrnetParam = null;
            try {
                getCurrnetParam = searcher.getClass().getMethod("get" + funSuffix, new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                continue;
            }
            Object member = null;
            try {
                member = getCurrnetParam.invoke(searcher, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                continue;
            }
            if (member == null) continue;
            if (QueryParam.class.isAssignableFrom(field.getType())) {
                QueryParam baseMember = (QueryParam)member;
                if (baseMember.isEmpty()) continue;
                result.add(baseMember.getCondition() + " " + SelectSqler.getAlias(searcher) + "." + columnName + " " + baseMember.toSqlPart() + " ");
                continue;
            }
            if (!field.getType().isAnnotationPresent(Search.class)) continue;
            result.addAll(SelectSqler.toWhere(member));
        }
        return result;
    }

    private static String getFormatWhere(Object searcher) {
        LinkedList<String> wheres = SelectSqler.toWhere(searcher);
        Collections.sort(wheres, new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                return str1.trim().compareToIgnoreCase(str2.trim());
            }
        });
        StringBuffer resultBuffer = new StringBuffer();
        for (String where : wheres) {
            resultBuffer.append(where);
        }
        String result = resultBuffer.toString();
        result = result.trim().isEmpty() ? "1=1 " : result.substring(result.indexOf(" ") + 1);
        return result;
    }

    private static String getTable(Class<?> searcherType) {
        Class<?> entityType = SelectSqler.getModelType(searcherType);
        if (entityType.isAnnotationPresent(Table.class)) {
            Table table = entityType.getAnnotation(Table.class);
            if (table.value().trim().isEmpty()) {
                throw new OperationNotSupportedException(entityType.getName() + "\u7c7b\u7684@Table\u6ce8\u89e3\u6ca1\u6709\u8d4b\u503c");
            }
            return table.value();
        }
        throw new OperationNotSupportedException(entityType.getName() + "\u7c7b\u6ca1\u6709@Table\u6ce8\u89e3");
    }

    private static String getPrimaryKeyName(Class<?> modelType) {
        List<Field> fields = Arrays.asList(modelType.getDeclaredFields());
        fields = new ArrayList<Field>(fields);
        Class<?> superClass = modelType.getSuperclass();
        if (superClass != null) {
            while (!superClass.equals(Object.class)) {
                fields.addAll(Arrays.asList(superClass.getDeclaredFields()));
                superClass = superClass.getSuperclass();
            }
        }
        String primaryKeyName = null;
        for (Field field : fields) {
            Column column;
            String strColumn;
            if (!field.isAnnotationPresent(PrimaryKey.class)) continue;
            primaryKeyName = field.getName();
            if (!field.isAnnotationPresent(Column.class) || (strColumn = (column = field.getAnnotation(Column.class)).value().trim()).isEmpty()) break;
            primaryKeyName = strColumn;
            break;
        }
        if (primaryKeyName == null) {
            throw new OperationNotSupportedException(modelType.getName() + "\u7c7b\u7684\u6210\u5458\u6ca1\u6709@PrimaryKey\u6ce8\u89e3");
        }
        return primaryKeyName;
    }

    private static Class<?> getModelType(Class<?> searcherType) {
        if (searcherType == null) {
            throw new OperationNotSupportedException("\u4f20\u5165\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (searcherType.isAnnotationPresent(Search.class)) {
            Search search = searcherType.getAnnotation(Search.class);
            if (search.value() != null) {
                return search.value();
            }
            throw new OperationNotSupportedException("\u8be5\u7c7b@Search\u6ce8\u89e3\u6ca1\u6709\u8d4b\u503c");
        }
        throw new OperationNotSupportedException("\u8be5\u7c7b\u6ca1\u6709\u6807\u6ce8@Search\u6ce8\u89e3");
    }
}

