/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.luava.cache.impl.redis;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.linuxprobe.luava.cache.Cache;
import org.springframework.data.redis.connection.RedisConnectionCommands;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.serializer.RedisSerializer;

public class RedisCache
implements Cache {
    public static final String RedisKeyCharset = "UTF-8";
    private final RedisTemplate<Serializable, Serializable> redisTemplate;

    public RedisTemplate<Serializable, Serializable> getRedisTemplate() {
        return this.redisTemplate;
    }

    public RedisCache(RedisTemplate<Serializable, Serializable> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public <V extends Serializable, K extends Serializable> void set(K key, V value, long timeout) {
        if (timeout == 0L) {
            this.redisTemplate.opsForValue().set(key, value);
        } else {
            this.redisTemplate.opsForValue().set(key, value, timeout, TimeUnit.SECONDS);
        }
    }

    @Override
    public <V extends Serializable, K extends Serializable> void set(K key, V value, long timeout, TimeUnit timeUnit) {
        if (timeout == 0L) {
            this.redisTemplate.opsForValue().set(key, value);
        } else {
            this.redisTemplate.opsForValue().set(key, value, timeout, timeUnit);
        }
    }

    @Override
    public <V extends Serializable, K extends Serializable> void set(K key, V value) {
        this.redisTemplate.opsForValue().set(key, value);
    }

    @Override
    public <V extends Serializable, K extends Serializable> V get(K key) {
        return (V)((Serializable)this.redisTemplate.opsForValue().get(key));
    }

    public <T extends Serializable> T getAndSetExpire(String key, long timeout) {
        Serializable result = (Serializable)this.redisTemplate.opsForValue().get((Object)key);
        if (result != null) {
            this.setExpire(key, timeout);
        }
        return (T)result;
    }

    public boolean exists(String key) {
        Boolean result = this.redisTemplate.hasKey((Object)key);
        return result == null ? false : result;
    }

    public Boolean setNx(String key, String value) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value);
    }

    public Boolean setExpireAt(String key, Date date) {
        return this.redisTemplate.expireAt((Object)key, date);
    }

    @Override
    public <T extends Serializable> void setExpire(T key, long timeout) {
        this.redisTemplate.expire(key, timeout, TimeUnit.SECONDS);
    }

    @Override
    public void flushDB() {
        this.redisTemplate.execute(connection -> {
            connection.flushDb();
            return null;
        });
    }

    @Override
    public long dbSize() {
        Long result = (Long)this.redisTemplate.execute(RedisServerCommands::dbSize);
        return result == null ? 0L : result;
    }

    public String ping() {
        return (String)this.redisTemplate.execute(RedisConnectionCommands::ping);
    }

    @Override
    public <T extends Serializable> void delete(T ... keys) {
        if (keys == null || keys.length == 0) {
            return;
        }
        this.redisTemplate.execute(connection -> {
            RedisSerializer serializer = this.redisTemplate.getKeySerializer();
            for (Serializable key : keys) {
                connection.del((byte[][])new byte[][]{serializer.serialize((Object)key)});
            }
            return null;
        });
    }

    @Override
    public <T extends Serializable> void delete(Collection<T> keys) {
        if (keys == null || keys.size() == 0) {
            return;
        }
        this.redisTemplate.execute(connection -> {
            RedisSerializer serializer = this.redisTemplate.getKeySerializer();
            for (Serializable key : keys) {
                connection.del((byte[][])new byte[][]{serializer.serialize((Object)key)});
            }
            return null;
        });
    }

    public <V extends Serializable> Set<V> keys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    @Override
    public <V extends Serializable, K extends Serializable> boolean setNX(K key, V value) {
        Boolean result = this.redisTemplate.opsForValue().setIfAbsent(key, value);
        if (result == null) {
            result = false;
        }
        return result;
    }

    @Override
    public <V extends Serializable, K extends Serializable> Serializable getAndSet(K key, V value) {
        return (Serializable)this.redisTemplate.opsForValue().getAndSet(key, value);
    }

    public Set<String> scan(String pattern) {
        HashSet<String> keys = new HashSet<String>();
        this.scan(pattern, item -> {
            String key = new String((byte[])item, StandardCharsets.UTF_8);
            keys.add(key);
        });
        return keys;
    }

    public void scan(String pattern, Consumer<byte[]> consumer) {
        this.redisTemplate.execute(connection -> {
            Cursor cursor = connection.scan(ScanOptions.scanOptions().count(Long.MAX_VALUE).match(pattern).build());
            cursor.forEachRemaining(consumer);
            return null;
        });
    }
}

