/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.luava.cache.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.linuxprobe.luava.cache.Cache;

public class DefaultCache
implements Cache {
    private final Map<Serializable, Serializable> keyMapValue = new ConcurrentHashMap<Serializable, Serializable>();
    private final Map<Serializable, Long> keyMapTimeout = new ConcurrentHashMap<Serializable, Long>();

    private boolean isEffective(Serializable key) {
        boolean result = true;
        Long timeOut = this.keyMapTimeout.get(key);
        if (timeOut == null) {
            result = false;
        } else if (timeOut != 0L && System.currentTimeMillis() >= this.keyMapTimeout.get(key)) {
            this.keyMapValue.remove(key);
            this.keyMapTimeout.remove(key);
            result = false;
        }
        return result;
    }

    @Override
    public <V extends Serializable, K extends Serializable> void set(K key, V value, long timeout) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout cannot be less than 0");
        }
        this.keyMapValue.put(key, value);
        if (timeout == 0L) {
            this.keyMapTimeout.put(key, 0L);
        }
        this.keyMapTimeout.put(key, System.currentTimeMillis() + timeout * 1000L);
    }

    @Override
    public <V extends Serializable, K extends Serializable> void set(K key, V value, long timeout, TimeUnit timeUnit) {
        this.set(key, value, timeUnit.toSeconds(timeout));
    }

    @Override
    public <V extends Serializable, K extends Serializable> V get(K key) {
        Serializable result = null;
        if (this.isEffective(key)) {
            result = this.keyMapValue.get(key);
        }
        return (V)result;
    }

    @Override
    public <V extends Serializable, K extends Serializable> void set(K key, V value) {
        this.set(key, value, 0L, TimeUnit.SECONDS);
    }

    @Override
    @SafeVarargs
    public final <T extends Serializable> void delete(T ... keys) {
        if (keys != null) {
            for (T key : keys) {
                this.keyMapValue.remove(key);
                this.keyMapTimeout.remove(key);
            }
        }
    }

    @Override
    public <T extends Serializable> void delete(Collection<T> keys) {
        if (keys != null) {
            for (Serializable key : keys) {
                this.keyMapValue.remove(key);
                this.keyMapTimeout.remove(key);
            }
        }
    }

    @Override
    public <T extends Serializable> void setExpire(T key, long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout cannot be less than 0");
        }
        if (timeout == 0L) {
            this.keyMapTimeout.put(key, 0L);
        }
        this.keyMapTimeout.put(key, System.currentTimeMillis() + timeout * 1000L);
    }

    @Override
    public <T extends Serializable> Set<T> keys(String pattern) {
        Set<Serializable> existKeys = this.keyMapValue.keySet();
        HashSet<Serializable> result = new HashSet<Serializable>();
        for (Serializable existKey : existKeys) {
            if (!this.isEffective(existKey) || !existKey.toString().matches(pattern)) continue;
            result.add(existKey);
        }
        return result;
    }

    @Override
    public synchronized <V extends Serializable, K extends Serializable> boolean setNX(K key, V value) {
        if (!this.isEffective(key)) {
            this.set(key, value);
            return true;
        }
        return false;
    }

    @Override
    public <V extends Serializable, K extends Serializable> Serializable getAndSet(K key, V value) {
        V existValue = this.get(key);
        this.set(key, value);
        return existValue;
    }

    @Override
    public synchronized void flushDB() {
        this.keyMapTimeout.clear();
        this.keyMapValue.clear();
    }

    @Override
    public long dbSize() {
        long result = 0L;
        Set<Serializable> existKeys = this.keyMapValue.keySet();
        for (Serializable existKey : existKeys) {
            if (!this.isEffective(existKey)) continue;
            ++result;
        }
        return result;
    }
}

