/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.luava.cache.impl.redis;

import java.io.Serializable;
import java.util.Date;
import java.util.Random;
import org.linuxprobe.luava.cache.impl.redis.RedisCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisLock {
    private static final Logger logger = LoggerFactory.getLogger(RedisLock.class);
    private static ThreadLocal<String> threadLocalValue = new ThreadLocal();

    public static boolean lock(RedisCache redisCache, String lockKey, long expires) {
        String value = String.valueOf(new Date().getTime() / 1000L + expires);
        boolean setSuccess = redisCache.setNX(lockKey, value);
        boolean result = false;
        if (!setSuccess) {
            String newValue;
            String oldValue;
            String currentValue = (String)redisCache.get(lockKey);
            if (currentValue != null && Long.parseLong(currentValue) < new Date().getTime() / 1000L && (oldValue = (String)((Object)redisCache.getAndSet(lockKey, newValue = String.valueOf(new Date().getTime() / 1000L + expires)))) != null && oldValue.equals(currentValue)) {
                result = true;
                threadLocalValue.set(newValue);
                logger.debug(lockKey + "\u5b58\u5728\u65e0\u6548\u9501\uff0c\u91cd\u7f6e\u5e76\u52a0\u9501\u6210\u529f");
            }
        } else {
            result = true;
            threadLocalValue.set(value);
            logger.debug(lockKey + "\u52a0\u9501\u6210\u529f");
        }
        if (!result) {
            logger.debug(lockKey + "\u52a0\u9501\u5931\u8d25");
        }
        return result;
    }

    public static void unlock(RedisCache redisCache, String lockKey) {
        String value = (String)redisCache.get(lockKey);
        if (value != null) {
            if (value.equals(threadLocalValue.get())) {
                redisCache.delete((Serializable[])new String[]{lockKey});
                logger.debug(lockKey + "\u89e3\u9501\u6210\u529f");
            } else {
                logger.debug(lockKey + "\u9501\u5df2\u7ecf\u5176\u5b83\u7ebf\u7a0b\u6216\u670d\u52a1\u5668\u91cd\u7f6e\uff0c\u65e0\u9700\u89e3\u9501");
            }
        } else {
            logger.debug(lockKey + "\u65e0\u9501\uff0c\u65e0\u9700\u89e3\u9501");
        }
        threadLocalValue.remove();
        Random random = new Random();
        try {
            Thread.sleep(random.nextInt(100));
        }
        catch (InterruptedException e) {
            new RuntimeException(e);
        }
    }
}

