/*
 * Decompiled with CFR 0.152.
 */
package org.linuxprobe.luava.cache.impl.redis;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.linuxprobe.luava.cache.Cache;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.serializer.RedisSerializer;

public class RedisCache
implements Cache {
    public static final String RedisKeyCharset = "UTF-8";
    private RedisTemplate<Serializable, Serializable> redisTemplate;

    public RedisTemplate<Serializable, Serializable> getRedisTemplate() {
        return this.redisTemplate;
    }

    public RedisCache(RedisTemplate<Serializable, Serializable> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public <V extends Serializable, K extends Serializable> void set(K key, V value, long timeout) {
        if (timeout == 0L) {
            this.redisTemplate.opsForValue().set(key, value);
        } else {
            this.redisTemplate.opsForValue().set(key, value, timeout, TimeUnit.SECONDS);
        }
    }

    @Override
    public <V extends Serializable, K extends Serializable> void set(K key, V value, long timeout, TimeUnit timeUnit) {
        if (timeout == 0L) {
            this.redisTemplate.opsForValue().set(key, value);
        } else {
            this.redisTemplate.opsForValue().set(key, value, timeout, timeUnit);
        }
    }

    @Override
    public <V extends Serializable, K extends Serializable> void set(K key, V value) {
        this.redisTemplate.opsForValue().set(key, value);
    }

    @Override
    public <V extends Serializable, K extends Serializable> V get(K key) {
        return (V)((Serializable)this.redisTemplate.opsForValue().get(key));
    }

    public <T extends Serializable> T getAndSetExpire(String key, long timeout) {
        Serializable result = (Serializable)this.redisTemplate.opsForValue().get((Object)key);
        if (result != null) {
            this.setExpire(key, timeout);
        }
        return (T)result;
    }

    public boolean exists(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Boolean setNx(String key, String value) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value);
    }

    public String getStringFromList(final String key) {
        return (String)this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                return new String(connection.rPop(key.getBytes(Charset.forName(RedisCache.RedisKeyCharset))), Charset.forName(RedisCache.RedisKeyCharset));
            }
        });
    }

    public long getListLength(final String key) {
        return (Long)this.redisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.lLen(key.getBytes());
            }
        });
    }

    public Long addElementsToSet(final String key, final byte[] ... elements) {
        return (Long)this.redisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                if (connection.isClosed()) {
                    connection = RedisCache.this.redisTemplate.getConnectionFactory().getConnection();
                }
                Long effectLen = connection.sAdd(key.getBytes(), elements);
                return effectLen;
            }
        });
    }

    public Long remElementsFromSet(final String key, final byte[] ... elements) {
        return (Long)this.redisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                if (connection.isClosed()) {
                    connection = RedisCache.this.redisTemplate.getConnectionFactory().getConnection();
                }
                Long effectLen = connection.sRem(key.getBytes(Charset.forName(RedisCache.RedisKeyCharset)), elements);
                return effectLen;
            }
        });
    }

    public Long getSetSize(final String key) {
        return (Long)this.redisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                if (connection.isClosed()) {
                    connection = RedisCache.this.redisTemplate.getConnectionFactory().getConnection();
                }
                Long effectLen = connection.sCard(key.getBytes(Charset.forName(RedisCache.RedisKeyCharset)));
                return effectLen;
            }
        });
    }

    public byte[] getAndRemoveElementFromSet(final String key) {
        return (byte[])this.redisTemplate.execute((RedisCallback)new RedisCallback<byte[]>(){

            public byte[] doInRedis(RedisConnection connection) throws DataAccessException {
                if (connection.isClosed()) {
                    connection = RedisCache.this.redisTemplate.getConnectionFactory().getConnection();
                }
                byte[] element = connection.sPop(key.getBytes(Charset.forName(RedisCache.RedisKeyCharset)));
                return element;
            }
        });
    }

    public Set<byte[]> getElementsFromSet(final String key) {
        return (Set)this.redisTemplate.execute((RedisCallback)new RedisCallback<Set<byte[]>>(){

            public Set<byte[]> doInRedis(RedisConnection connection) throws DataAccessException {
                if (connection.isClosed()) {
                    connection = RedisCache.this.redisTemplate.getConnectionFactory().getConnection();
                }
                Set elements = connection.sMembers(key.getBytes(Charset.forName(RedisCache.RedisKeyCharset)));
                return elements;
            }
        });
    }

    public Boolean setExpireAt(String key, Date date) {
        return this.redisTemplate.expireAt((Object)key, date);
    }

    @Override
    public <T extends Serializable> void setExpire(T key, long timeout) {
        this.redisTemplate.expire(key, timeout, TimeUnit.SECONDS);
    }

    public void publish(String channel, Object message) {
        this.redisTemplate.convertAndSend(channel, message);
    }

    @Override
    public void flushDB() {
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Void>(){

            public Void doInRedis(RedisConnection connection) throws DataAccessException {
                connection.flushDb();
                return null;
            }
        });
    }

    @Override
    public long dbSize() {
        return (Long)this.redisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.dbSize();
            }
        });
    }

    public String ping() {
        return (String)this.redisTemplate.execute((RedisCallback)new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.ping();
            }
        });
    }

    @Override
    public <T extends Serializable> void delete(final T ... keys) {
        if (keys == null || keys.length == 0) {
            return;
        }
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Void>(){

            public Void doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer serializer = RedisCache.this.redisTemplate.getKeySerializer();
                for (int i = 0; i < keys.length; ++i) {
                    connection.del((byte[][])new byte[][]{serializer.serialize((Object)keys[i])});
                }
                return null;
            }
        });
    }

    @Override
    public <T extends Serializable> void delete(final Collection<T> keys) {
        if (keys == null || keys.size() == 0) {
            return;
        }
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Void>(){

            public Void doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer serializer = RedisCache.this.redisTemplate.getKeySerializer();
                for (Serializable key : keys) {
                    connection.del((byte[][])new byte[][]{serializer.serialize((Object)key)});
                }
                return null;
            }
        });
    }

    public Set<Serializable> keys(String pattern) {
        HashSet<Serializable> result = new HashSet<Serializable>(this.redisTemplate.keys((Object)pattern));
        return result;
    }

    @Override
    public <V extends Serializable, K extends Serializable> boolean setNX(K key, V value) {
        return this.redisTemplate.opsForValue().setIfAbsent(key, value);
    }

    @Override
    public <V extends Serializable, K extends Serializable> Serializable getAndSet(K key, V value) {
        return (Serializable)this.redisTemplate.opsForValue().getAndSet(key, value);
    }

    public Set<String> scan(String pattern) {
        HashSet<String> keys = new HashSet<String>();
        this.scan(pattern, item -> {
            String key = new String((byte[])item, StandardCharsets.UTF_8);
            keys.add(key);
        });
        return keys;
    }

    public void scan(String pattern, Consumer<byte[]> consumer) {
        this.redisTemplate.execute(connection -> {
            Cursor cursor = connection.scan(ScanOptions.scanOptions().count(Long.MAX_VALUE).match(pattern).build());
            cursor.forEachRemaining(consumer);
            return null;
        });
    }
}

