/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.samples.gettingstarted.pmo;

import com.vaadin.server.FontAwesome;
import com.vaadin.ui.Notification;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.linkki.core.ui.section.annotations.AvailableValuesType;
import org.linkki.core.ui.section.annotations.EnabledType;
import org.linkki.core.ui.section.annotations.ModelObject;
import org.linkki.core.ui.section.annotations.RequiredType;
import org.linkki.core.ui.section.annotations.UIButton;
import org.linkki.core.ui.section.annotations.UIComboBox;
import org.linkki.core.ui.section.annotations.UILabel;
import org.linkki.core.ui.section.annotations.UISection;
import org.linkki.core.ui.section.annotations.UITextArea;
import org.linkki.samples.gettingstarted.model.Report;
import org.linkki.samples.gettingstarted.model.ReportType;

@UISection
public class ReportSectionPmo {
    private final Report report;

    public ReportSectionPmo(Report report) {
        this.report = Objects.requireNonNull(report, "report must not be null");
    }

    @ModelObject
    public Report getReport() {
        return this.report;
    }

    @UITextArea(position=10, label="Description", rows=5, columns=50)
    public void description() {
    }

    @UILabel(position=20, label="Type")
    @UIComboBox(position=20, label="Type", required=RequiredType.REQUIRED, content=AvailableValuesType.DYNAMIC)
    public void type() {
    }

    @UIButton(position=30, caption="Send", icon=FontAwesome.SEND, showIcon=true, enabled=EnabledType.DYNAMIC)
    public void send() {
        this.report.save();
        Notification.show((String)String.format("Report with id %d filed!", this.report.getId()), (String)"Thank you for reporting!", (Notification.Type)Notification.Type.TRAY_NOTIFICATION);
    }

    public boolean isSendEnabled() {
        String description = this.report.getDescription();
        return description != null && !description.isEmpty() && this.report.getType() != null;
    }

    public List<ReportType> getTypeAvailableValues() {
        return Arrays.asList(ReportType.values());
    }

    public Class<?> getTypeComponentType() {
        return null;
    }
}

