/*
 * Copyright Faktor Zehn AG.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.linkki.samples.gettingstarted.pmo;

import static java.util.Objects.requireNonNull;

import java.util.Arrays;
import java.util.List;

import org.linkki.core.ui.section.annotations.AvailableValuesType;
import org.linkki.core.ui.section.annotations.EnabledType;
import org.linkki.core.ui.section.annotations.ModelObject;
import org.linkki.core.ui.section.annotations.RequiredType;
import org.linkki.core.ui.section.annotations.UIButton;
import org.linkki.core.ui.section.annotations.UIComboBox;
import org.linkki.core.ui.section.annotations.UILabel;
import org.linkki.core.ui.section.annotations.UISection;
import org.linkki.core.ui.section.annotations.UITextArea;
import org.linkki.samples.gettingstarted.model.Report;
import org.linkki.samples.gettingstarted.model.ReportType;

import com.vaadin.server.FontAwesome;
import com.vaadin.ui.Notification;

@UISection
public class ReportSectionPmo {

	private final Report report;

	public ReportSectionPmo(Report report) {
		this.report = requireNonNull(report, "report must not be null");
	}

	@ModelObject
	public Report getReport() { return report; }

	@UITextArea(
			position = 10,
			label = "Description",
			rows = 5, columns = 50)
	public void description() {}

	@UILabel(position = 20, label = "Type")
	@UIComboBox(
			position = 20,
			label = "Type",
			required = RequiredType.REQUIRED,
			content = AvailableValuesType.DYNAMIC
			)
	public void type() {}

	@UIButton(
			position = 30,
			caption = "Send",
			icon = FontAwesome.SEND,
			showIcon = true,
			enabled = EnabledType.DYNAMIC)
	public void send() {
		report.save();
		Notification.show(String.format("Report with id %d filed!", report.getId()), "Thank you for reporting!",
				Notification.Type.TRAY_NOTIFICATION);
	}

	public boolean isSendEnabled() {
		String description = report.getDescription();
		return description != null && !description.isEmpty() && report.getType() != null;
	}
	
	public List<ReportType> getTypeAvailableValues() {
		return Arrays.asList(ReportType.values());
	}

	public Class<?> getTypeComponentType() {
		return null;
	}
}