/*

* Copyright Faktor Zehn AG.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.linkki.samples.gettingstarted.model;

// tag::report-type[]
public enum ReportType {

    BUG,
    IMPROVEMENT,
    QUESTION;

    // end::report-type[]


    /**
     * This method is called from linkki to display a caption for the enum value.
     * 
     * @return the representation for the enum value
     */
    // tag::report-type[]
    public String getName() {
        String name = name();
        return name.substring(0, 1) + name.substring(1).toLowerCase();
    }
}
// end::report-type[]