/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.component.sidebar;

import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.linkki.core.binding.manager.UiUpdateObserver;
import org.linkki.util.LazyReference;

public class SidebarSheet {
    private final Button button;
    private final String name;
    private final LazyReference<Component> contentSupplier;
    private final Optional<UiUpdateObserver> uiUpdateObserver;

    @Deprecated
    public SidebarSheet(Resource icon, Component content, String tooltip) {
        this(icon, tooltip, content);
    }

    public SidebarSheet(Resource icon, String name, Component content) {
        this(icon, name, () -> content);
    }

    public SidebarSheet(Resource icon, String name, Component content, UiUpdateObserver uiUpdateObserver) {
        this(icon, name, () -> content, uiUpdateObserver);
    }

    public SidebarSheet(Resource icon, String name, Supplier<Component> contentSupplier) {
        this(icon, name, contentSupplier, null);
    }

    public SidebarSheet(Resource icon, String name, Supplier<Component> contentSupplier, @CheckForNull UiUpdateObserver uiUpdateObserver) {
        this.button = new Button("", Objects.requireNonNull(icon, "icon must not be null"));
        this.contentSupplier = new LazyReference(Objects.requireNonNull(contentSupplier, "content must not be null"));
        this.name = Objects.requireNonNull(name, "tooltip must not be null");
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            this.button.setDescription(name);
        }
        this.uiUpdateObserver = Optional.ofNullable(uiUpdateObserver);
    }

    public Button getButton() {
        return this.button;
    }

    public Component getContent() {
        return (Component)this.contentSupplier.getReference();
    }

    public String getName() {
        return this.name;
    }

    protected void select() {
        this.getContent().setVisible(true);
        this.getButton().addStyleName("selected");
        this.uiUpdateObserver.ifPresent(UiUpdateObserver::uiUpdated);
    }

    protected void unselect() {
        this.getButton().removeStyleName("selected");
        this.getContent().setVisible(false);
    }

    public String toString() {
        return this.name;
    }
}

