/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.component;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.linkki.core.binding.validation.message.Message;
import org.linkki.core.defaults.ui.aspects.annotations.BindTooltip;
import org.linkki.core.defaults.ui.aspects.types.TooltipType;
import org.linkki.core.ui.aspects.annotation.BindStyleNames;
import org.linkki.core.ui.element.annotation.UILabel;
import org.linkki.core.ui.table.column.annotation.UITableColumn;
import org.linkki.framework.ui.component.MessageUiComponents;

public class MessageRowPmo {
    private final Message message;

    public MessageRowPmo(Message message) {
        this.message = Objects.requireNonNull(message, "message must not be null");
    }

    @UITableColumn(expandRatio=0.0f)
    @UILabel(position=10, htmlContent=true)
    @BindTooltip(tooltipType=TooltipType.DYNAMIC)
    @BindStyleNames
    public String getIcon() {
        return MessageUiComponents.getIcon(this.message.getSeverity()).getHtml();
    }

    public List<String> getIconStyleNames() {
        return Arrays.asList("linkki-message-row", MessageUiComponents.getStyle(this.message.getSeverity()));
    }

    public String getIconTooltip() {
        return MessageUiComponents.getInvalidObjectPropertiesAsString(this.message);
    }

    @UITableColumn(expandRatio=1.0f)
    @UILabel(position=20, styleNames={"linkki-message-row"})
    public String getText() {
        return this.message.getText();
    }
}

