/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.application.menu;

import com.vaadin.ui.MenuBar;
import java.util.Objects;
import org.linkki.framework.ui.application.menu.ApplicationMenu;

public abstract class ApplicationMenuItemDefinition
implements Comparable<ApplicationMenuItemDefinition> {
    private String name;
    private int position;

    public ApplicationMenuItemDefinition(String name, int position) {
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.position = position;
    }

    public String getName() {
        return this.name;
    }

    public int getPosition() {
        return this.position;
    }

    public MenuBar.MenuItem createItem(ApplicationMenu menu) {
        MenuBar.MenuItem item = this.internalCreateItem(menu);
        item.setStyleName("linkki-application-menu");
        return item;
    }

    protected abstract MenuBar.MenuItem internalCreateItem(ApplicationMenu var1);

    @Override
    public int compareTo(ApplicationMenuItemDefinition other) {
        Objects.requireNonNull(other, "other must not be null");
        int positionCompare = this.position - other.position;
        if (positionCompare == 0) {
            return this.name.compareTo(other.name);
        }
        return positionCompare;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.position;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationMenuItemDefinition other = (ApplicationMenuItemDefinition)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        return this.position == other.position;
    }
}

