/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.application;

import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewProvider;
import com.vaadin.server.ErrorHandler;
import com.vaadin.server.Page;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import org.linkki.core.ui.converters.LinkkiConverterRegistry;
import org.linkki.framework.state.ApplicationConfig;
import org.linkki.framework.ui.application.ApplicationLayout;
import org.linkki.framework.ui.application.ApplicationNavigator;
import org.linkki.framework.ui.dialogs.DefaultErrorDialog;
import org.linkki.framework.ui.dialogs.DialogErrorHandler;

public class LinkkiUi
extends UI {
    private static final long serialVersionUID = 1L;
    private ApplicationConfig applicationConfig;
    private ApplicationLayout applicationLayout;

    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="applicationConfig/Layout will be non-null once configure was called")
    protected LinkkiUi() {
    }

    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="applicationConfig/Layout will be non-null once configure was called")
    public LinkkiUi(ApplicationConfig applicationConfig) {
        this.configure(applicationConfig);
    }

    protected final void configure(ApplicationConfig config) {
        this.applicationConfig = Objects.requireNonNull(config, "config must not be null");
        this.applicationLayout = this.applicationConfig.createApplicationLayout();
        this.setNavigator(config.createApplicationNavigator(this, this.applicationLayout));
    }

    public ApplicationNavigator getNavigator() {
        return (ApplicationNavigator)super.getNavigator();
    }

    protected void init(VaadinRequest request) {
        Objects.requireNonNull(this.applicationConfig, "configure must be called before any other methods to set applicationConfig and applicationLayout");
        this.setErrorHandler(this.createErrorHandler());
        VaadinSession vaadinSession = VaadinSession.getCurrent();
        if (vaadinSession != null) {
            vaadinSession.setAttribute(LinkkiConverterRegistry.class, (Object)this.applicationConfig.getConverterRegistry());
            vaadinSession.setErrorHandler(this.getErrorHandler());
        }
        Page.getCurrent().setTitle(this.getPageTitle());
        this.setContent((Component)this.applicationLayout);
    }

    protected ErrorHandler createErrorHandler() {
        return new DialogErrorHandler(this.getNavigator(), DefaultErrorDialog::new);
    }

    protected void addView(String viewName, Class<? extends View> viewClass) {
        this.getNavigator().addView(viewName, viewClass);
    }

    protected void addProvider(ViewProvider provider) {
        this.getNavigator().addProvider(provider);
    }

    protected String getPageTitle() {
        return this.getApplicationConfig().getApplicationName();
    }

    public ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    public ApplicationLayout getApplicationLayout() {
        return this.applicationLayout;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="when called from the constructor before configure")
    public void setContent(@CheckForNull Component content) {
        if (this.applicationLayout != null && !(content instanceof ApplicationLayout)) {
            throw new IllegalArgumentException("content must be an " + ApplicationLayout.class.getSimpleName());
        }
        this.applicationLayout = (ApplicationLayout)content;
        super.setContent(content);
    }

    public static LinkkiUi getCurrent() {
        return (LinkkiUi)UI.getCurrent();
    }

    public static ApplicationConfig getCurrentApplicationConfig() {
        return LinkkiUi.getCurrent().getApplicationConfig();
    }

    public static ApplicationNavigator getCurrentApplicationNavigator() {
        return LinkkiUi.getCurrent().getNavigator();
    }

    public static ApplicationLayout getCurrentApplicationLayout() {
        return LinkkiUi.getCurrent().getApplicationLayout();
    }
}

