/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.dialogs;

import com.vaadin.server.ErrorEvent;
import com.vaadin.server.ErrorHandler;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.linkki.framework.ui.application.ApplicationNavigator;
import org.linkki.framework.ui.dialogs.ConfirmationDialog;
import org.linkki.util.handler.Handler;

public class DialogErrorHandler
implements ErrorHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(DialogErrorHandler.class.getName());
    private static final String DEFAULT_START_VIEW = "";
    private final ApplicationNavigator applicationNavigator;
    private final String startView;
    private final BiFunction<ErrorEvent, Handler, ConfirmationDialog> dialogCreator;

    public DialogErrorHandler(ApplicationNavigator applicationNavigator, BiFunction<ErrorEvent, Handler, ConfirmationDialog> dialogCreator) {
        this(applicationNavigator, dialogCreator, DEFAULT_START_VIEW);
    }

    public DialogErrorHandler(ApplicationNavigator applicationNavigator, BiFunction<ErrorEvent, Handler, ConfirmationDialog> dialogCreator, String startView) {
        this.applicationNavigator = applicationNavigator;
        this.dialogCreator = dialogCreator;
        this.startView = startView;
    }

    public void error(ErrorEvent event) {
        LOGGER.log(Level.SEVERE, "Unhandled exception", event.getThrowable());
        this.showErrorDialog(event);
    }

    private void showErrorDialog(ErrorEvent errorEvent) {
        ConfirmationDialog dialog = this.dialogCreator.apply(errorEvent, this::navigateToStartView);
        dialog.open();
    }

    @SuppressFBWarnings
    private void navigateToStartView() {
        UI ui = UI.getCurrent();
        new ArrayList<Window>(ui.getWindows()).forEach(arg_0 -> ((UI)ui).removeWindow(arg_0));
        this.applicationNavigator.showView(this.startView);
    }
}

