/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.component.sidebar;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import org.linkki.framework.ui.component.sidebar.SidebarSheet;

public class SidebarLayout
extends CssLayout {
    private static final long serialVersionUID = -8283594476427895723L;
    private final CssLayout sidebar;
    private final CssLayout contentArea;
    private final List<SidebarSheet> sidebarSheets = new ArrayList<SidebarSheet>();
    @CheckForNull
    private SidebarSheet selected;

    public SidebarLayout() {
        this.sidebar = new CssLayout();
        this.contentArea = new CssLayout();
        this.setSizeFull();
        this.contentArea.setSizeFull();
        this.setStyleName("linkki-sidebar-layout");
        this.sidebar.setStyleName("linkki-sidebar");
        this.contentArea.setStyleName("linkki-sidebar-content");
        this.addComponent((Component)this.sidebar);
        this.addComponent((Component)this.contentArea);
    }

    public void addSheets(Stream<SidebarSheet> sheets) {
        sheets.forEach(this::addSheet);
    }

    public void addSheets(Iterable<SidebarSheet> sheets) {
        sheets.forEach(this::addSheet);
    }

    public void addSheets(SidebarSheet ... sheets) {
        this.addSheets(Arrays.stream(sheets));
    }

    public void addSheet(SidebarSheet sheet) {
        this.sidebarSheets.add(sheet);
        sheet.getButton().addClickListener((Button.ClickListener & Serializable)e -> this.select(sheet));
        this.sidebar.addComponent((Component)sheet.getButton());
        if (this.selected == null) {
            this.select(sheet);
        }
    }

    public void select(SidebarSheet sheet) {
        if (!this.sidebarSheets.contains(sheet)) {
            throw new IllegalArgumentException("The sheet " + sheet + " is not part of this SidebarLayout");
        }
        if (this.selected == sheet) {
            return;
        }
        Component content = sheet.getContent();
        if (content.getParent() == null) {
            this.contentArea.addComponent(content);
        } else if (content.getParent() != this.contentArea) {
            throw new IllegalStateException("Content of the selected sidebar sheet already has a parent!");
        }
        if (this.selected != null) {
            this.selected.unselect();
        }
        this.selected = sheet;
        sheet.select();
    }

    public SidebarSheet getSelected() {
        if (this.selected != null) {
            return this.selected;
        }
        throw new NoSuchElementException();
    }

    public List<SidebarSheet> getSidebarSheets() {
        return Collections.unmodifiableList(this.sidebarSheets);
    }

    CssLayout getContentArea() {
        return this.contentArea;
    }

    CssLayout getSidebar() {
        return this.sidebar;
    }
}

