/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.component;

import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import com.vaadin.v7.ui.Table;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.linkki.core.binding.BindingContext;
import org.linkki.core.binding.validation.message.Message;
import org.linkki.core.binding.validation.message.MessageList;
import org.linkki.core.binding.validation.message.ObjectProperty;
import org.linkki.core.binding.validation.message.Severity;
import org.linkki.core.defaults.columnbased.pmo.ContainerPmo;
import org.linkki.core.ui.creation.table.PmoBasedTableFactory;
import org.linkki.framework.ui.component.MessageTablePmo;

public final class MessageUiComponents {
    private MessageUiComponents() {
    }

    public static String getStyle(Severity severity) {
        return "linkki-message-" + severity.name().toLowerCase();
    }

    public static VaadinIcons getIcon(Severity severity) {
        switch (severity) {
            case ERROR: {
                return VaadinIcons.EXCLAMATION_CIRCLE;
            }
            case WARNING: {
                return VaadinIcons.WARNING;
            }
        }
        return VaadinIcons.INFO_CIRCLE;
    }

    public static String getInvalidObjectPropertiesAsString(Message message) {
        String text = message.getInvalidObjectProperties().stream().map(MessageUiComponents::toString).collect(Collectors.joining(", "));
        return text;
    }

    private static String toString(ObjectProperty op) {
        String simpleName = op.getObject().getClass().getSimpleName();
        if (StringUtils.isEmpty((CharSequence)op.getProperty())) {
            return simpleName;
        }
        return simpleName + ": " + op.getProperty();
    }

    public static Component createMessageComponent(Message message) {
        FormLayout component = new FormLayout();
        Label messageLabel = new Label();
        messageLabel.setWidth("100%");
        messageLabel.setValue(message.getText());
        Severity severity = message.getSeverity();
        messageLabel.setIcon((Resource)MessageUiComponents.getIcon(severity));
        messageLabel.addStyleName("linkki-message-label");
        messageLabel.addStyleName(MessageUiComponents.getStyle(severity));
        messageLabel.setDescription(MessageUiComponents.getInvalidObjectPropertiesAsString(message));
        component.addComponent((Component)messageLabel);
        return component;
    }

    public static Component createMessageTable(Supplier<MessageList> messages, BindingContext bindingContext) {
        Table table = new PmoBasedTableFactory((ContainerPmo)new MessageTablePmo(messages), bindingContext).createTable();
        table.setColumnHeaderMode(Table.ColumnHeaderMode.HIDDEN);
        table.setStyleName("linkki-message-table");
        table.setWidth("100%");
        return table;
    }

    public static Component createMessageTable(String title, Supplier<MessageList> messages, BindingContext bindingContext) {
        Component messageTable = MessageUiComponents.createMessageTable(messages, bindingContext);
        messageTable.setCaption(title);
        return messageTable;
    }
}

