/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.application;

import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.MenuBar;
import java.io.Serializable;
import org.linkki.framework.state.ApplicationConfig;
import org.linkki.framework.ui.application.LinkkiUi;
import org.linkki.framework.ui.application.menu.ApplicationMenu;
import org.linkki.framework.ui.dialogs.ApplicationInfoDialog;
import org.linkki.framework.ui.nls.NlsText;
import org.linkki.framework.ui.pmo.ApplicationInfoPmo;

public class ApplicationHeader
extends HorizontalLayout {
    private static final long serialVersionUID = 1L;
    private final ApplicationMenu applicationMenu;

    public ApplicationHeader(ApplicationMenu applicationMenu) {
        this.applicationMenu = applicationMenu;
        this.addStyleName("linkki-application-header");
        this.setWidth("100%");
        this.setMargin(new MarginInfo(true, false, true, false));
    }

    protected void init() {
        this.addLeftComponents();
        this.addRightComponents();
    }

    protected void addLeftComponents() {
        this.addComponent((Component)this.applicationMenu);
    }

    @Deprecated
    protected void addRightComponents() {
        HorizontalLayout wrapper = new HorizontalLayout();
        wrapper.setStyleName("linkki-application-header-right");
        wrapper.setDefaultComponentAlignment(Alignment.MIDDLE_RIGHT);
        wrapper.setSizeFull();
        wrapper.setSpacing(true);
        this.addRightComponents(wrapper);
        this.addComponent((Component)wrapper);
        this.setExpandRatio((Component)wrapper, 1.0f);
        if (wrapper.getComponentCount() > 0) {
            wrapper.setExpandRatio(wrapper.getComponent(0), 1.0f);
        }
    }

    protected void addRightComponents(HorizontalLayout parent) {
        parent.addComponent((Component)this.createRightMenuBar());
    }

    protected MenuBar createRightMenuBar() {
        MenuBar rightMenuBar = new MenuBar();
        rightMenuBar.addStyleName("borderless");
        rightMenuBar.addStyleName("small");
        this.addHelpMenu(rightMenuBar);
        return rightMenuBar;
    }

    protected MenuBar.MenuItem addHelpMenu(MenuBar parent) {
        MenuBar.MenuItem helpMenu = parent.addItem("", (Resource)VaadinIcons.QUESTION_CIRCLE, null);
        this.addHelpMenuItems(helpMenu);
        return helpMenu;
    }

    protected void addHelpMenuItems(MenuBar.MenuItem helpMenu) {
        this.addApplicationInfoMenuItem(helpMenu);
    }

    protected void addApplicationInfoMenuItem(MenuBar.MenuItem helpMenu) {
        helpMenu.addItem(NlsText.getString("ApplicationHeader.Info"), (Resource)VaadinIcons.INFO_CIRCLE, (MenuBar.Command & Serializable)i -> new ApplicationInfoDialog(this.createApplicationInfoPmo(LinkkiUi.getCurrentApplicationConfig())).open());
    }

    protected ApplicationInfoPmo createApplicationInfoPmo(ApplicationConfig applicationConfig) {
        return new ApplicationInfoPmo(applicationConfig);
    }

    protected MenuBar.MenuItem addUserMenu(String username, MenuBar parent) {
        MenuBar.MenuItem userMenu = parent.addItem(username, (Resource)VaadinIcons.USER, null);
        this.addUserMenuItems(userMenu);
        return userMenu;
    }

    protected void addUserMenuItems(MenuBar.MenuItem userMenu) {
        userMenu.addItem(NlsText.getString("ApplicationHeader.Logout"), this.newLogoutCommand());
    }

    protected MenuBar.Command newLogoutCommand() {
        return (MenuBar.Command & Serializable)selectedItem -> this.getUI().getPage().setLocation("./logout");
    }
}

