/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.pmo;

import org.linkki.core.ui.section.annotations.UILabel;
import org.linkki.core.ui.section.annotations.UISection;
import org.linkki.framework.state.ApplicationConfig;
import org.linkki.framework.ui.nls.NlsText;

@UISection
public class ApplicationInfoPmo {
    private ApplicationConfig applicationConfig;

    public ApplicationInfoPmo(ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    @UILabel(position=10, htmlContent=true)
    public String getTitle() {
        return "<h2>" + this.getApplicationConfig().getApplicationName() + "</h2>";
    }

    @UILabel(position=20, htmlContent=true)
    public String getVersion() {
        return NlsText.getString("ApplicationInfoPmo.Version") + ": " + this.getApplicationConfig().getApplicationVersion();
    }

    @UILabel(position=30, htmlContent=true)
    public String getDescription() {
        return "<p>" + this.getApplicationConfig().getApplicationDescription() + "</p>";
    }

    @UILabel(position=40, htmlContent=true)
    public String getCopyright() {
        return "<p>" + this.getApplicationConfig().getCopyright() + "</p>";
    }

    public ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    public String getDialogCaption() {
        return NlsText.getString("ApplicationInfoPmo.About") + " " + this.getApplicationConfig().getApplicationName();
    }

    public String getDialogWidth() {
        return "600px";
    }
}

