/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.dialogs;

import com.vaadin.ui.Component;
import java.util.Objects;
import org.linkki.core.binding.BindingContext;
import org.linkki.core.binding.dispatcher.behavior.PropertyBehavior;
import org.linkki.core.binding.dispatcher.behavior.PropertyBehaviorProvider;
import org.linkki.core.binding.validation.ValidationService;
import org.linkki.core.ui.section.AbstractSection;
import org.linkki.core.ui.section.PmoBasedSectionFactory;
import org.linkki.framework.ui.dialogs.DialogBindingManager;
import org.linkki.framework.ui.dialogs.OkCancelDialog;
import org.linkki.util.handler.Handler;

public class PmoBasedDialogFactory {
    private final PmoBasedSectionFactory pmoBasedSectionFactory;
    private final ValidationService validationService;
    private final PropertyBehaviorProvider propertyBehaviorProvider;

    public PmoBasedDialogFactory() {
        this(ValidationService.NOP_VALIDATION_SERVICE);
    }

    public PmoBasedDialogFactory(ValidationService validationService) {
        this(validationService, PropertyBehaviorProvider.NO_BEHAVIOR_PROVIDER);
    }

    public PmoBasedDialogFactory(PropertyBehavior ... propertyBehavior) {
        this(ValidationService.NOP_VALIDATION_SERVICE, PropertyBehaviorProvider.with((PropertyBehavior[])propertyBehavior));
    }

    public PmoBasedDialogFactory(ValidationService validationService, PropertyBehaviorProvider propertyBehaviorProvider) {
        this.validationService = Objects.requireNonNull(validationService, "validationService must not be null");
        this.propertyBehaviorProvider = Objects.requireNonNull(propertyBehaviorProvider, "propertyBehaviorProvider must not be null");
        this.pmoBasedSectionFactory = new PmoBasedSectionFactory();
    }

    @Deprecated
    public OkCancelDialog newOkCancelDialog(String title, Object pmo, Handler okHandler) {
        return this.newOkCancelDialog(title, okHandler, pmo);
    }

    public OkCancelDialog newOkDialog(String title, Object ... pmos) {
        return this.newOkCancelDialog(title, Handler.NOP_HANDLER, new Object[]{OkCancelDialog.ButtonOption.OK_ONLY, pmos});
    }

    public OkCancelDialog newOkCancelDialog(String title, Handler okHandler, Object ... pmos) {
        return this.newOkCancelDialog(title, okHandler, Handler.NOP_HANDLER, OkCancelDialog.ButtonOption.OK_CANCEL, pmos);
    }

    public OkCancelDialog newOkCancelDialog(String title, Handler okHandler, Handler cancelHandler, Object ... pmos) {
        return this.newOkCancelDialog(title, okHandler, cancelHandler, OkCancelDialog.ButtonOption.OK_CANCEL, pmos);
    }

    OkCancelDialog newOkCancelDialog(String title, Handler okHandler, Handler cancelHandler, OkCancelDialog.ButtonOption buttonOption, Object ... pmos) {
        OkCancelDialog dialog = OkCancelDialog.builder(title).okHandler(okHandler).cancelHandler(cancelHandler).buttonOption(buttonOption).build();
        DialogBindingManager bindingManager = new DialogBindingManager(dialog, this.validationService, this.propertyBehaviorProvider);
        BindingContext bindingContext = bindingManager.startNewContext(((Object)((Object)dialog)).getClass());
        for (Object pmo : pmos) {
            AbstractSection content = this.pmoBasedSectionFactory.createSection(pmo, bindingContext);
            float expRatio = 0.0f;
            if (pmo == pmos[pmos.length - 1]) {
                expRatio = 1.0f;
            }
            dialog.addContent((Component)content, expRatio);
        }
        bindingContext.modelChanged();
        return dialog;
    }

    public OkCancelDialog openOkCancelDialog(String title, Object pmo, Handler okHandler) {
        OkCancelDialog dialog = this.newOkCancelDialog(title, okHandler, pmo);
        dialog.open();
        return dialog;
    }

    @Deprecated
    public static OkCancelDialog open(OkCancelDialog dialog) {
        dialog.open();
        return dialog;
    }
}

