/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.dialogs;

import com.vaadin.server.Page;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.linkki.core.binding.validation.ValidationDisplayState;
import org.linkki.core.binding.validation.ValidationService;
import org.linkki.core.binding.validation.message.Message;
import org.linkki.core.binding.validation.message.MessageList;
import org.linkki.framework.ui.component.MessageRow;
import org.linkki.framework.ui.nls.NlsText;
import org.linkki.util.handler.Handler;

public class OkCancelDialog
extends Window {
    private static final long serialVersionUID = 1L;
    private final VerticalLayout layout;
    private final VerticalLayout contentArea;
    private final VerticalLayout mainArea;
    private final Button okButton;
    private final Handler okHandler;
    private final Handler cancelHandler;
    private ValidationService validationService = ValidationService.NOP_VALIDATION_SERVICE;
    private ValidationDisplayState validationDisplayState = ValidationDisplayState.HIDE_MANDATORY_FIELD_VALIDATIONS;
    private Handler beforeOkHandler = Handler.NOP_HANDLER;
    private Optional<MessageRow> messageRow = Optional.empty();
    private boolean okPressed = false;
    private boolean cancelPressed = false;
    private boolean mayProceed = true;

    protected OkCancelDialog(String caption, Handler okHandler, Handler cancelHandler, ButtonOption buttonOption, Component ... contentComponents) {
        super(caption);
        this.okHandler = Objects.requireNonNull(okHandler, "okHandler must not be null");
        this.cancelHandler = Objects.requireNonNull(cancelHandler, "cancelHandler must not be null");
        this.layout = new VerticalLayout();
        this.contentArea = new VerticalLayout();
        this.mainArea = new VerticalLayout();
        this.okButton = new Button(NlsText.getString("OkCancelDialog.OkButtonCaption"));
        this.okButton.setClickShortcut(13, new int[0]);
        this.okButton.setStyleName("primary");
        this.initDialogWindow();
        this.initLayout();
        this.initMainArea(contentComponents);
        this.initButtons(buttonOption);
        this.initCloseListener();
        super.setContent((Component)this.layout);
        this.center();
    }

    @Deprecated
    public OkCancelDialog(String caption) {
        this(caption, Handler.NOP_HANDLER, Handler.NOP_HANDLER, ButtonOption.OK_CANCEL, new Component[0]);
    }

    @Deprecated
    public OkCancelDialog(String caption, Handler okHandler) {
        this(caption, okHandler, Handler.NOP_HANDLER, ButtonOption.OK_CANCEL, new Component[0]);
    }

    @Deprecated
    public OkCancelDialog(String caption, Handler okHandler, ButtonOption buttonOption) {
        this(caption, okHandler, Handler.NOP_HANDLER, buttonOption, new Component[0]);
    }

    @Deprecated
    public OkCancelDialog(String caption, Component content, Handler okHandler, ButtonOption buttonOption) {
        this(caption, okHandler, Handler.NOP_HANDLER, buttonOption, OkCancelDialog.toArray(content));
    }

    private static Component[] toArray(@CheckForNull Component contentComponent) {
        if (contentComponent == null) {
            return new Component[0];
        }
        return new Component[]{contentComponent};
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="yeah, we know...")
    public void setContent(@CheckForNull Component content) {
        if (this.mainArea == null) {
            super.setContent(content);
        } else {
            this.mainArea.removeAllComponents();
            this.mainArea.addComponent(content);
        }
    }

    private void initDialogWindow() {
        this.setStyleName("linkki-dialog-caption");
        this.setModal(true);
        this.setResizable(false);
    }

    private void initLayout() {
        this.layout.setWidth("100%");
        this.layout.setMargin(true);
        this.layout.addComponent((Component)this.contentArea);
        this.layout.setExpandRatio((Component)this.contentArea, 1.0f);
    }

    private void initMainArea(Component ... contentComponents) {
        this.mainArea.addStyleName("linkki-dialog-content");
        this.contentArea.addStyleName("content-area");
        this.contentArea.addComponent((Component)this.mainArea);
        this.contentArea.setExpandRatio((Component)this.mainArea, 1.0f);
        for (Component contentComponent : contentComponents) {
            this.mainArea.addComponent(contentComponent);
        }
    }

    private void initButtons(ButtonOption buttonOption) {
        HorizontalLayout buttons = this.createButtons(buttonOption);
        this.layout.addComponent((Component)buttons);
        this.layout.setExpandRatio((Component)buttons, 0.0f);
        this.layout.setComponentAlignment((Component)buttons, Alignment.MIDDLE_CENTER);
    }

    private void initCloseListener() {
        this.addCloseListener((Window.CloseListener & Serializable)e -> {
            if (!this.isOkPressed() && !this.isCancelPressed()) {
                this.cancel();
            }
        });
    }

    private HorizontalLayout createButtons(ButtonOption buttonOption) {
        HorizontalLayout buttons = new HorizontalLayout();
        buttons.addStyleName("linkki-dialog-button-bar");
        buttons.setSpacing(true);
        buttons.addComponent((Component)this.okButton);
        buttons.setComponentAlignment((Component)this.okButton, Alignment.BOTTOM_CENTER);
        this.okButton.addClickListener((Button.ClickListener & Serializable)e -> {
            this.setOkPressed();
            this.beforeOkHandler.andThen(() -> {
                if (this.mayProceed) {
                    this.ok();
                    this.close();
                }
            }).apply();
        });
        if (buttonOption == ButtonOption.OK_CANCEL) {
            Button cancel = new Button(NlsText.getString("OkCancelDialog.CancelButtonCaption"));
            buttons.addComponent((Component)cancel);
            buttons.setComponentAlignment((Component)cancel, Alignment.MIDDLE_CENTER);
            cancel.addClickListener((Button.ClickListener & Serializable)e -> {
                this.setCancelPressed(true);
                this.cancel();
                this.close();
            });
        }
        return buttons;
    }

    public void setSize(String width, String height) {
        this.setHeight(height);
        this.setWidth(width);
        this.layout.setSizeFull();
        this.contentArea.setSizeFull();
        this.mainArea.setSizeFull();
    }

    public MessageList validate() {
        MessageList messages = this.validationDisplayState.filter(this.getValidationService().getValidationMessages());
        this.messageRow.ifPresent(arg_0 -> ((VerticalLayout)this.contentArea).removeComponent(arg_0));
        messages.getSeverity().flatMap(arg_0 -> ((MessageList)messages).getFirstMessage(arg_0)).ifPresent(this::addMessageRow);
        this.mayProceed = !messages.containsErrorMsg();
        this.okButton.setEnabled(this.mayProceed);
        return messages;
    }

    private void addMessageRow(Message message) {
        MessageRow newRow = new MessageRow(message);
        newRow.setWidth("100%");
        this.messageRow = Optional.of(newRow);
        this.contentArea.addComponent((Component)newRow);
        this.contentArea.setExpandRatio((Component)newRow, 0.0f);
        this.contentArea.setComponentAlignment((Component)newRow, Alignment.MIDDLE_LEFT);
    }

    public ValidationService getValidationService() {
        return this.validationService;
    }

    public void setValidationService(ValidationService validationService) {
        this.validationService = Objects.requireNonNull(validationService, "validationService must not be null");
    }

    public void setBeforeOkHandler(Handler beforeOkHandler) {
        this.beforeOkHandler = beforeOkHandler;
    }

    public OkCancelDialog open() {
        UI current = UI.getCurrent();
        if (current != null) {
            current.addWindow((Window)this);
            this.initURIChangeListener();
        }
        return this;
    }

    protected void initURIChangeListener() {
        UI current = UI.getCurrent();
        current.getPage().addUriFragmentChangedListener((Page.UriFragmentChangedListener & Serializable)e -> this.close());
    }

    public void addContent(Component c) {
        this.mainArea.addComponent(c);
    }

    public void addContent(Component c, float expandRatio) {
        this.mainArea.addComponent(c);
        this.mainArea.setExpandRatio(c, expandRatio);
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public ValidationDisplayState getValidationDisplayState() {
        return this.validationDisplayState;
    }

    private void setOkPressed() {
        this.okPressed = true;
        this.validationDisplayState = ValidationDisplayState.SHOW_ALL;
    }

    public boolean isCancelPressed() {
        return this.cancelPressed;
    }

    private void setCancelPressed(boolean cancelPressed) {
        this.cancelPressed = cancelPressed;
    }

    protected void ok() {
        this.okHandler.apply();
    }

    protected void cancel() {
        this.cancelHandler.apply();
    }

    public static Builder builder(String caption) {
        return new Builder(caption);
    }

    public static class Builder {
        private String caption;
        private Component[] contentComponents = new Component[0];
        private Handler okHandler = Handler.NOP_HANDLER;
        private Handler cancelHandler = Handler.NOP_HANDLER;
        private ButtonOption buttonOption = ButtonOption.OK_CANCEL;
        @CheckForNull
        private String width;
        @CheckForNull
        private String height;

        Builder(String caption) {
            this.caption = Objects.requireNonNull(caption, "caption must not be null");
        }

        public Builder content(Component ... contentComponents) {
            this.contentComponents = Objects.requireNonNull(contentComponents, "content must not be null");
            return this;
        }

        public Builder okHandler(Handler okHandler) {
            this.okHandler = Objects.requireNonNull(okHandler, "okHandler must not be null");
            return this;
        }

        public Builder cancelHandler(Handler cancelHandler) {
            this.cancelHandler = Objects.requireNonNull(cancelHandler, "cancelHandler must not be null");
            return this;
        }

        public Builder buttonOption(ButtonOption buttonOption) {
            this.buttonOption = Objects.requireNonNull(buttonOption, "buttonOption must not be null");
            return this;
        }

        public Builder size(String width, String height) {
            this.width = Objects.requireNonNull(width, "width must not be null");
            this.height = Objects.requireNonNull(height, "height must not be null");
            return this;
        }

        public OkCancelDialog build() {
            OkCancelDialog createdDialog = new OkCancelDialog(this.caption, this.okHandler, this.cancelHandler, this.buttonOption, this.contentComponents);
            if (StringUtils.isNotBlank((CharSequence)this.width) && StringUtils.isNotBlank((CharSequence)this.height)) {
                createdDialog.setSize(this.width, this.height);
            }
            return createdDialog;
        }
    }

    public static enum ButtonOption {
        OK_ONLY,
        OK_CANCEL;

    }
}

