/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.ui.dialogs;

import com.vaadin.server.ErrorEvent;
import com.vaadin.ui.AbstractTextField;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.linkki.framework.ui.dialogs.ConfirmationDialog;
import org.linkki.framework.ui.nls.NlsText;
import org.linkki.util.handler.Handler;

public class DefaultErrorDialog
extends ConfirmationDialog {
    private static final long serialVersionUID = 1L;

    public DefaultErrorDialog(ErrorEvent errorEvent, Handler navigateToStartView) {
        super(NlsText.getString("DefaultErrorHandler.errorDialogTitle"), navigateToStartView, new Component[]{DefaultErrorDialog.createContent(errorEvent)});
        this.setSize("80em", "40em");
    }

    private static VerticalLayout createContent(ErrorEvent errorEvent) {
        LocalDateTime timestamp = LocalDateTime.now();
        VerticalLayout content = new VerticalLayout();
        content.addComponent((Component)DefaultErrorDialog.createLabelWithTimestamp(timestamp));
        content.addComponent((Component)DefaultErrorDialog.createRootCauseTextField(errorEvent.getThrowable()));
        content.addComponent((Component)DefaultErrorDialog.createStackTraceTextArea(errorEvent.getThrowable()));
        DefaultErrorDialog.formatContent(content);
        return content;
    }

    private static Label createLabelWithTimestamp(LocalDateTime timestamp) {
        String formattedTimestamp = timestamp.format(DateTimeFormatter.ofPattern(NlsText.getString("DefaultErrorHandler.timestampFormat")));
        return new Label(NlsText.format("DefaultErrorHandler.errorDialogText", formattedTimestamp));
    }

    private static TextField createRootCauseTextField(@CheckForNull Throwable t) {
        TextField textField = new TextField(NlsText.getString("DefaultErrorHandler.errorDialogDescription"));
        String message = Optional.ofNullable(ExceptionUtils.getRootCause((Throwable)t)).map(e -> e.getLocalizedMessage()).orElse(ExceptionUtils.getRootCauseMessage((Throwable)t));
        textField.setValue(message);
        textField.setNullRepresentation(NlsText.getString("DefaultErrorHandler.nullRepresentation"));
        DefaultErrorDialog.formatText((AbstractTextField)textField);
        return textField;
    }

    private static TextArea createStackTraceTextArea(@CheckForNull Throwable t) {
        TextArea textArea = new TextArea(NlsText.getString("DefaultErrorHandler.errorDialogDetails"));
        textArea.setNullRepresentation(NlsText.getString("DefaultErrorHandler.nullRepresentation"));
        textArea.setValue(ExceptionUtils.getStackTrace((Throwable)t));
        DefaultErrorDialog.formatText((AbstractTextField)textArea);
        return textArea;
    }

    private static void formatText(AbstractTextField textArea) {
        textArea.setReadOnly(true);
        textArea.setSizeFull();
    }

    private static void formatContent(VerticalLayout content) {
        content.setSizeFull();
        content.setExpandRatio(content.getComponent(0), 5.0f);
        content.setExpandRatio(content.getComponent(1), 10.0f);
        content.setExpandRatio(content.getComponent(2), 85.0f);
        content.setSpacing(true);
    }
}

