/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.framework.state;

import com.vaadin.data.util.converter.ConverterFactory;
import com.vaadin.ui.UI;
import java.util.Optional;
import java.util.function.Function;
import org.linkki.core.ui.converters.LinkkiConverterFactory;
import org.linkki.framework.ui.application.ApplicationFooter;
import org.linkki.framework.ui.application.ApplicationHeader;
import org.linkki.framework.ui.application.ApplicationLayout;
import org.linkki.framework.ui.application.ApplicationNavigator;
import org.linkki.framework.ui.application.menu.ApplicationMenu;
import org.linkki.framework.ui.application.menu.ApplicationMenuItemDefinition;
import org.linkki.util.Sequence;

public interface ApplicationConfig {
    public String getApplicationName();

    public String getApplicationVersion();

    public String getApplicationDescription();

    public String getCopyright();

    default public ApplicationLayout createApplicationLayout() {
        ApplicationFooter footer = this.getFooterDefinition().map(fd -> fd.apply(this)).orElse(null);
        return new ApplicationLayout(this.getHeaderDefinition().apply(new ApplicationMenu(this.getMenuItemDefinitions().list())), footer);
    }

    public Sequence<ApplicationMenuItemDefinition> getMenuItemDefinitions();

    default public ApplicationHeaderDefinition getHeaderDefinition() {
        return ApplicationHeader::new;
    }

    default public Optional<ApplicationFooterDefinition> getFooterDefinition() {
        return Optional.empty();
    }

    default public ApplicationNavigator createApplicationNavigator(UI ui, ApplicationLayout applicationLayout) {
        return new ApplicationNavigator(ui, applicationLayout);
    }

    default public ConverterFactory getConverterFactory() {
        return new LinkkiConverterFactory();
    }

    @FunctionalInterface
    public static interface ApplicationFooterDefinition
    extends Function<ApplicationConfig, ApplicationFooter> {
        public ApplicationFooter createApplicationFooter(ApplicationConfig var1);

        @Override
        default public ApplicationFooter apply(ApplicationConfig applicationConfig) {
            return this.createApplicationFooter(applicationConfig);
        }
    }

    @FunctionalInterface
    public static interface ApplicationHeaderDefinition
    extends Function<ApplicationMenu, ApplicationHeader> {
        public ApplicationHeader createApplicationHeader(ApplicationMenu var1);

        @Override
        default public ApplicationHeader apply(ApplicationMenu applicationMenu) {
            return this.createApplicationHeader(applicationMenu);
        }
    }
}

