/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;

public final class TypeUtils {
    private final List<Type> visited = new ArrayList<Type>();

    private TypeUtils() {
    }

    private String toString(Type type, boolean qualify) {
        this.visited.add(type);
        String result = null;
        if (type instanceof TypeVariable) {
            result = this.printTypeVariable((TypeVariable)type, qualify);
        } else if (type instanceof ParameterizedType) {
            result = this.printParameterizedType((ParameterizedType)type, qualify);
        } else if (type instanceof Class) {
            result = this.printClass((Class)type, qualify);
        } else if (type instanceof GenericArrayType) {
            result = this.printGenericArrayDeclaration((GenericArrayType)type, qualify);
        } else if (type instanceof WildcardType) {
            result = this.printWildcardType((WildcardType)type);
        } else {
            throw new IllegalStateException("Unknown type '" + type + "'");
        }
        return result;
    }

    public static String toString(Type type) {
        return new TypeUtils().toString(type, false);
    }

    private String printClass(Class<?> clazz, boolean qualify) {
        String result = null;
        result = qualify ? (clazz.isInterface() ? "interface " : (clazz.isPrimitive() ? "" : "class ")) + clazz.getCanonicalName() : clazz.getCanonicalName();
        return result;
    }

    private String printGenericArrayDeclaration(GenericArrayType type, boolean qualify) {
        String componentType = this.toString(type.getGenericComponentType(), qualify);
        if (componentType.indexOf(32) > 0) {
            return String.format("(%s)[]", componentType);
        }
        return componentType.concat("[]");
    }

    private String printParameterizedType(ParameterizedType type, boolean qualify) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.toString(type.getRawType(), qualify));
        if (type.getActualTypeArguments().length > 0) {
            builder.append("<");
            boolean first = true;
            for (Type s : type.getActualTypeArguments()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                if (this.visited.contains(s)) {
                    builder.append(s);
                    continue;
                }
                builder.append(this.toString(s, false));
            }
            builder.append(">");
        }
        return builder.toString();
    }

    private String printTypeVariable(TypeVariable<?> variable, boolean qualify) {
        StringBuilder builder = new StringBuilder();
        if (qualify) {
            builder.append("<");
            builder.append(variable.getGenericDeclaration());
            builder.append("> ");
        }
        builder.append(this.printBounds(variable.getName(), variable.getBounds(), false));
        return builder.toString();
    }

    private String printWildcardType(WildcardType type) {
        boolean hasLowerBounds;
        Type[] bounds = type.getLowerBounds();
        boolean bl = hasLowerBounds = bounds.length > 0;
        if (!hasLowerBounds) {
            bounds = type.getUpperBounds();
        }
        return this.printBounds("?", bounds, hasLowerBounds);
    }

    private String printBounds(String name, Type[] bounds, boolean lower) {
        StringBuilder builder = new StringBuilder();
        builder.append(name);
        if (bounds.length > 0) {
            String prefix = lower ? "super" : "extends";
            builder.append(" ").append(prefix).append(" ");
            for (int i = 0; i < bounds.length; ++i) {
                if (i > 0) {
                    builder.append(" & ");
                }
                Type bound = bounds[i];
                builder.append(this.toString(bound, false));
            }
        }
        return builder.toString();
    }
}

