/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeanUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanUtils.class);

    private BeanUtils() {
    }

    public static boolean isGetter(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == 0 && BeanUtils.isProperlyDefined(method);
    }

    private static boolean isProperlyDefined(Method method) {
        return BeanUtils.isNonBooleanGetter(method) || BeanUtils.isBooleanGetter(method);
    }

    private static boolean isBooleanGetter(Method method) {
        String name = method.getName();
        return name.startsWith("is") && name.length() > 2 && method.getReturnType() == Boolean.TYPE;
    }

    private static boolean isNonBooleanGetter(Method method) {
        String name = method.getName();
        return name.startsWith("get") && name.length() > 3 && method.getReturnType() != Void.TYPE;
    }

    public static Method getSetter(Method getter) {
        return BeanUtils.getSetter(getter.getDeclaringClass(), BeanUtils.getPropertyName(getter), getter.getReturnType());
    }

    public static Method findSetter(Class<?> clazz, String propertyName, Class<?> propertyType) {
        Class<?> ctx = clazz;
        Method result = null;
        while (ctx != null && result == null) {
            result = BeanUtils.getSetter(ctx, propertyName, propertyType);
            if ((ctx = ctx.getSuperclass()) != Object.class) continue;
            ctx = null;
        }
        return result;
    }

    private static Method getSetter(Class<?> clazz, String propertyName, Class<?> propertyType) {
        Method candidate;
        String setterName = "set" + BeanUtils.capitalize(propertyName);
        try {
            candidate = clazz.getDeclaredMethod(setterName, propertyType);
            if (candidate.getReturnType() != Void.TYPE || !Modifier.isPublic(candidate.getModifiers())) {
                candidate = null;
            }
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.trace("Could not find setter method public void {}({}) in class {}", new Object[]{setterName, propertyType.getName(), clazz.getName(), e});
            candidate = null;
        }
        return candidate;
    }

    public static String getPropertyName(Method method) {
        Class<?> resultType;
        String name = method.getName();
        if (name.startsWith("get")) {
            name = BeanUtils.decapitalize(name.substring(3));
        } else if (name.startsWith("is") && (resultType = method.getReturnType()) == Boolean.TYPE) {
            name = BeanUtils.decapitalize(name.substring(2));
        }
        return name;
    }

    public static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }
}

