/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ReflectPermission;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.ldp4j.rdf.bean.JARBContext;
import org.ldp4j.rdf.bean.NamingPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RuntimeInstance {
    private static final String INSTANTIATE_ACTION = "instantiate";
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeInstance.class);
    public static final String RDF_BEAN_SPI_RUNTIMEINSTANCE_FINDER = "org.ldp4j.rdf.bean.spi.runtimeinstance.finder";
    public static final String RDF_BEAN_CFG = "rdf-bean.properties";
    public static final String RDF_BEAN_SPI_PROPERTY = "org.ldp4j.rdf.bean.spi.RuntimeInstance";
    private static final AtomicReference<RuntimeInstance> CACHED_DELEGATE = new AtomicReference();
    private static ReflectPermission suppressAccessChecksPermission = new ReflectPermission("suppressAccessChecks");

    protected RuntimeInstance() {
    }

    private static RuntimeInstance findDelegate() {
        try {
            String delegateClassName;
            RuntimeInstance result = RuntimeInstance.createRuntimeInstanceFromSPI();
            if (result == null) {
                result = RuntimeInstance.createRuntimeInstanceFromConfigurationFile();
            }
            if (result == null && (delegateClassName = System.getProperty(RDF_BEAN_SPI_PROPERTY)) != null) {
                result = RuntimeInstance.createRuntimeInstanceForClassName(delegateClassName);
            }
            if (result == null) {
                result = new DefaultRuntimeInstance();
            }
            return result;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not find runtime delegate", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RuntimeInstance createRuntimeInstanceFromConfigurationFile() {
        RuntimeInstance result = null;
        File configFile = RuntimeInstance.getConfigurationFile();
        if (configFile.canRead()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(configFile);
                Properties configProperties = new Properties();
                configProperties.load(is);
                String delegateClassName = configProperties.getProperty(RDF_BEAN_SPI_PROPERTY);
                if (delegateClassName != null) {
                    result = RuntimeInstance.createRuntimeInstanceForClassName(delegateClassName);
                }
                if (delegateClassName == null && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Configuration file '" + configFile.getAbsolutePath() + "' does not define a delegate class name");
                }
            }
            catch (FileNotFoundException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Could not find runtime instance configuration file '" + configFile.getAbsolutePath() + "'", (Throwable)e);
                }
            }
            catch (IOException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Could not load runtime instance configuration file '" + configFile.getAbsolutePath() + "'", (Throwable)e);
                }
            }
            finally {
                RuntimeInstance.closeQuietly(is, "Could find close properties");
            }
        }
        return result;
    }

    private static File getConfigurationFile() {
        return new File(new File(System.getProperty("java.home")), "lib" + File.separator + RDF_BEAN_CFG);
    }

    private static void closeQuietly(InputStream is, String message) {
        block3: {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn(message, (Throwable)e);
                }
            }
        }
    }

    private static RuntimeInstance createRuntimeInstanceFromSPI() {
        Iterator<RuntimeInstance> i$;
        if (!"disable".equalsIgnoreCase(System.getProperty(RDF_BEAN_SPI_RUNTIMEINSTANCE_FINDER)) && (i$ = ServiceLoader.load(RuntimeInstance.class).iterator()).hasNext()) {
            RuntimeInstance delegate = i$.next();
            return delegate;
        }
        return null;
    }

    private static RuntimeInstance createRuntimeInstanceForClassName(String delegateClassName) {
        RuntimeInstance result = null;
        try {
            Class<?> delegateClass = Class.forName(delegateClassName);
            if (RuntimeInstance.class.isAssignableFrom(delegateClass)) {
                Object impl = delegateClass.newInstance();
                result = (RuntimeInstance)RuntimeInstance.class.cast(impl);
            }
        }
        catch (ClassNotFoundException e) {
            RuntimeInstance.handleFailure(delegateClassName, "find", e);
        }
        catch (InstantiationException e) {
            RuntimeInstance.handleFailure(delegateClassName, INSTANTIATE_ACTION, e);
        }
        catch (IllegalAccessException e) {
            RuntimeInstance.handleFailure(delegateClassName, INSTANTIATE_ACTION, e);
        }
        return result;
    }

    private static void handleFailure(String delegateClassName, String action, Exception failure) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Could not " + action + " delegate class " + delegateClassName, (Throwable)failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RuntimeInstance getInstance() {
        RuntimeInstance result = CACHED_DELEGATE.get();
        if (result != null) {
            return result;
        }
        AtomicReference<RuntimeInstance> atomicReference = CACHED_DELEGATE;
        synchronized (atomicReference) {
            result = CACHED_DELEGATE.get();
            if (result == null) {
                CACHED_DELEGATE.set(RuntimeInstance.findDelegate());
                result = CACHED_DELEGATE.get();
            }
            return result;
        }
    }

    public static void setInstance(RuntimeInstance delegate) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(suppressAccessChecksPermission);
        }
        CACHED_DELEGATE.set(delegate);
    }

    public abstract JARBContext newContext(NamingPolicy var1);

    static class DefaultRuntimeInstance
    extends RuntimeInstance {
        private static final String ERROR_MESSAGE = String.format("No %s runtime instance found", RuntimeInstance.class);

        DefaultRuntimeInstance() {
        }

        @Override
        public JARBContext newContext(NamingPolicy policy) {
            throw new IllegalStateException(ERROR_MESSAGE);
        }
    }
}

