/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl.model;

import java.io.Serializable;
import java.util.Comparator;
import org.ldp4j.rdf.BlankNode;
import org.ldp4j.rdf.Resource;
import org.ldp4j.rdf.URIRef;
import org.ldp4j.rdf.bean.impl.model.ModelUtils;

final class ResourceComparator
implements Comparator<Resource<?>>,
Serializable {
    private static final long serialVersionUID = 3688707084336037225L;

    ResourceComparator() {
    }

    @Override
    public int compare(Resource<?> o1, Resource<?> o2) {
        int result = 0;
        result = o1 instanceof URIRef ? this.compareURI(o2, (URIRef)o1) : this.compareOther(o1, o2);
        return result;
    }

    private int compareOther(Resource<?> o1, Resource<?> o2) {
        if (o2 instanceof BlankNode) {
            return o1.toString().compareTo(o2.toString());
        }
        return 1;
    }

    private int compareURI(Resource<?> o2, URIRef uri) {
        if (o2 instanceof URIRef) {
            return ModelUtils.compare(uri, (URIRef)o2);
        }
        return -1;
    }
}

