/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl.model;

import java.net.URI;
import org.ldp4j.rdf.Resource;
import org.ldp4j.rdf.URIRef;

final class ModelUtils {
    private static final char COLON = ':';
    private static final char SLASH = '/';
    private static final char HASH = '#';

    private ModelUtils() {
    }

    private static boolean isCorrectColonNamespaceURISplit(String namespace, String localName, char lastNsChar) {
        return lastNsChar == ':' && ModelUtils.isValidColonLocalName(localName) && ModelUtils.isValidColonNamespace(namespace);
    }

    private static boolean isCorrectSlashNamespaceURISplit(String namespace, String localName, char lastNsChar) {
        return lastNsChar == '/' && ModelUtils.isValidSlashLocalName(localName) && ModelUtils.isValidSlashNamespace(namespace);
    }

    private static boolean isCorrectHashNamespaceURISplit(String namespace, int nsLength, char lastNsChar) {
        return lastNsChar == '#' && namespace.lastIndexOf(35, nsLength - 2) == -1;
    }

    private static boolean isValidSlashNamespace(String namespace) {
        return namespace.indexOf(35) == -1;
    }

    private static boolean isValidSlashLocalName(String localName) {
        return localName.indexOf(47) == -1 && localName.indexOf(35) == -1;
    }

    private static boolean isValidColonNamespace(String namespace) {
        return namespace.indexOf(35) == -1 && namespace.indexOf(47) == -1;
    }

    private static boolean isValidColonLocalName(String localName) {
        return localName.indexOf(58) == -1 && localName.indexOf(35) == -1 && localName.indexOf(47) == -1;
    }

    static int compare(URIRef u1, URIRef u2) {
        int res = Namespace.fromURI(u1).compare(Namespace.fromURI(u2));
        if (res != 0) {
            return res;
        }
        return u1.toString().compareTo(u2.toString());
    }

    static int getLocalNameIndex(String uri) {
        int separatorIdx = uri.indexOf(35);
        if (separatorIdx < 0) {
            separatorIdx = uri.lastIndexOf(47);
        }
        if (separatorIdx < 0) {
            separatorIdx = uri.lastIndexOf(58);
        }
        if (separatorIdx < 0) {
            throw new IllegalArgumentException("No separator character founds in URI: " + uri);
        }
        return separatorIdx + 1;
    }

    static boolean isCorrectURISplit(String namespace, String localName) {
        assert (namespace != null) : "namespace must not be null";
        assert (localName != null) : "localName must not be null";
        boolean result = false;
        int nsLength = namespace.length();
        if (nsLength > 0) {
            char lastNsChar = namespace.charAt(nsLength - 1);
            result = ModelUtils.isCorrectHashNamespaceURISplit(namespace, nsLength, lastNsChar) || ModelUtils.isCorrectSlashNamespaceURISplit(namespace, localName, lastNsChar) || ModelUtils.isCorrectColonNamespaceURISplit(namespace, localName, lastNsChar);
        }
        return result;
    }

    static String getNamespace(URIRef uri) {
        String uriString = ((URI)uri.getIdentity()).toString();
        int localNameIdx = ModelUtils.getLocalNameIndex(uriString);
        return uriString.substring(0, localNameIdx);
    }

    static String getLocalName(URIRef uri) {
        String uriString = ((URI)uri.getIdentity()).toString();
        int localNameIdx = ModelUtils.getLocalNameIndex(uriString);
        return uriString.substring(localNameIdx);
    }

    static String getIdentity(Resource<?> subject) {
        return subject.getIdentity().toString();
    }

    static enum Namespace {
        RDF("http://www.w3.org/1999/02/22-rdf-syntax-ns#", 1),
        RDFS("http://www.w3.org/2000/01/rdf-schema#", 2),
        OWL("http://www.w3.org/2002/07/owl#", 3),
        XML_SCHEMA("http://www.w3.org/2001/XMLSchema#", 4),
        UNKNOWN("UNKNOWN", 5);

        private final String id;
        private final int priority;

        private Namespace(String id, int priority) {
            this.id = id;
            this.priority = priority;
        }

        static Namespace fromURI(URIRef uri) {
            for (Namespace namespace : Namespace.values()) {
                if (!((URI)uri.getIdentity()).toString().startsWith(namespace.getId())) continue;
                return namespace;
            }
            return UNKNOWN;
        }

        int compare(Namespace n) {
            return this.priority - n.priority;
        }

        String getId() {
            return this.id;
        }
    }
}

