/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.ldp4j.rdf.BlankNode;
import org.ldp4j.rdf.Literal;
import org.ldp4j.rdf.Resource;
import org.ldp4j.rdf.URIRef;
import org.ldp4j.rdf.bean.impl.model.Assertions;
import org.ldp4j.rdf.bean.impl.model.AssertionsImpl;
import org.ldp4j.rdf.bean.impl.model.Individual;
import org.ldp4j.rdf.bean.impl.model.ModelUtils;
import org.ldp4j.rdf.bean.impl.model.ResourceComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class IndividualImpl
implements Individual,
Iterable<URIRef> {
    private static final String INDIVIDUAL_PARAM = "Individual cannot be null";
    private static final String PREDICATE_PARAM = "Predicate cannot be null";
    private static final String OBJECT_PARAM = "Object cannot be null";
    private static final Logger LOGGER = LoggerFactory.getLogger(IndividualImpl.class);
    private final Resource<?> subject;
    private final boolean anonymous;
    private final SortedSet<URIRef> predicates;
    private final Set<URIRef> protectedPredicates;
    private final Map<URIRef, AssertionsImpl> assertions;
    private final SortedSet<Resource<?>> referrers;
    private long references;

    IndividualImpl(Resource<?> subject) {
        this.subject = subject;
        this.anonymous = subject instanceof BlankNode;
        if (this.anonymous && LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Individual '%s' is anonymous", subject));
        }
        this.predicates = new TreeSet<URIRef>(new PredicateComparator());
        this.protectedPredicates = Collections.unmodifiableSet(this.predicates);
        this.assertions = new HashMap<URIRef, AssertionsImpl>();
        this.referrers = new TreeSet(new ResourceComparator());
        this.references = 0L;
    }

    @Override
    public Iterator<URIRef> iterator() {
        return this.protectedPredicates.iterator();
    }

    private AssertionsImpl findAssertions(URIRef predicate) {
        AssertionsImpl asserts = this.assertions.get(predicate);
        if (asserts == null) {
            asserts = new AssertionsImpl(predicate);
            this.predicates.add(predicate);
            this.assertions.put(predicate, asserts);
        }
        return asserts;
    }

    private void addReferrer(Resource<?> referrer) {
        if (LOGGER.isTraceEnabled() && !this.referrers.contains(referrer)) {
            LOGGER.trace(String.format("Resource '%s' is referenced by '%s'", this.subject, referrer));
        }
        this.referrers.add(referrer);
        ++this.references;
        if (LOGGER.isTraceEnabled() && this.references > 1L) {
            LOGGER.trace(String.format("Resource '%s' is referenced %d times", this.subject, this.references));
        }
    }

    void addAssertion(URIRef predicate, Literal<?> object) {
        Objects.requireNonNull(predicate, PREDICATE_PARAM);
        Objects.requireNonNull(object, OBJECT_PARAM);
        this.findAssertions(predicate).add(object);
    }

    void addLink(URIRef predicate, IndividualImpl individual) {
        Objects.requireNonNull(predicate, PREDICATE_PARAM);
        Objects.requireNonNull(individual, INDIVIDUAL_PARAM);
        this.findAssertions(predicate).add(individual);
        individual.addReferrer(this.subject);
    }

    @Override
    public Resource<?> getIdentity() {
        return this.subject;
    }

    @Override
    public Set<Literal<?>> getPropertyValues(URIRef predicate) {
        HashSet result = new HashSet();
        result.addAll(this.getAssertions(predicate).getLiterals());
        return result;
    }

    @Override
    public Set<Individual> getPropertyObjects(URIRef predicate) {
        HashSet<Individual> result = new HashSet<Individual>();
        result.addAll(this.getAssertions(predicate).getIndividuals());
        return result;
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public boolean isReference() {
        return this.assertions.isEmpty();
    }

    boolean isReferred() {
        return this.references > 0L;
    }

    boolean isFoldable() {
        return !this.isReference() && this.anonymous && this.referrers.size() == 1 && this.references == 1L;
    }

    boolean canBeFoldedBy(Resource<?> subject) {
        return this.isFoldable() && this.referrers.contains(subject);
    }

    Assertions getAssertions(URIRef predicate) {
        AssertionsImpl asserts = this.assertions.get(predicate);
        if (asserts == null) {
            asserts = new AssertionsImpl(predicate);
        }
        return asserts;
    }

    long getReferences() {
        return this.references;
    }

    Set<Resource<?>> getReferrers() {
        return Collections.unmodifiableSet(this.referrers);
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder out = new StringBuilder();
        out.append("Individual(").append(this.subject).append(") {").append(nl);
        for (URIRef predicate : this) {
            out.append("\t").append(this.getAssertions(predicate)).append(nl);
        }
        out.append("}");
        return out.toString();
    }

    @Override
    public Set<URIRef> getProperties() {
        return this.protectedPredicates;
    }

    private static final class PredicateComparator
    implements Comparator<URIRef>,
    Serializable {
        private static final long serialVersionUID = 2092671073721681488L;
        private static final String RDF_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";

        private PredicateComparator() {
        }

        @Override
        public int compare(URIRef o1, URIRef o2) {
            if (o1.toString().equals(RDF_TYPE)) {
                return -1;
            }
            if (o2.toString().equals(RDF_TYPE)) {
                return 1;
            }
            return ModelUtils.compare(o1, o2);
        }
    }
}

