/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl.model;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.ldp4j.rdf.Literal;
import org.ldp4j.rdf.Node;
import org.ldp4j.rdf.Resource;
import org.ldp4j.rdf.URIRef;
import org.ldp4j.rdf.bean.impl.model.Graph;
import org.ldp4j.rdf.bean.impl.model.Individual;
import org.ldp4j.rdf.bean.impl.model.IndividualImpl;
import org.ldp4j.rdf.bean.impl.model.ModelUtils;
import org.ldp4j.rdf.bean.impl.model.ResourceComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GraphImpl
implements Graph,
Iterable<Individual> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphImpl.class);
    private final Resource<?> base;
    private final SortedSet<Resource<?>> subjects;
    private final Map<Resource<?>, IndividualImpl> individuals;
    private final Map<String, String> definedNamespaces;
    private final SortedSet<String> usedNamespaces;

    public GraphImpl(Resource<?> base) {
        this.base = base;
        this.subjects = new TreeSet(new ResourceComparator());
        this.individuals = new HashMap();
        this.definedNamespaces = new HashMap<String, String>();
        this.usedNamespaces = new TreeSet<String>();
    }

    private void collectNamespace(Node element) {
        URIRef uriRef;
        if (element instanceof URIRef && ((URI)(uriRef = (URIRef)element).getIdentity()).isAbsolute() && !((URI)uriRef.getIdentity()).isOpaque()) {
            String namespace = ModelUtils.getNamespace(uriRef);
            if (LOGGER.isTraceEnabled() && !this.usedNamespaces.contains(namespace)) {
                LOGGER.trace(String.format("Collected namespace: %s", namespace));
            }
            this.usedNamespaces.add(namespace);
        }
    }

    private IndividualImpl getOrCreateIndividual(Resource<?> subject) {
        IndividualImpl asserts = this.individuals.get(subject);
        if (asserts == null) {
            asserts = new IndividualImpl(subject);
            this.subjects.add(subject);
            this.individuals.put(subject, asserts);
        }
        return asserts;
    }

    void addNamespace(String prefix, String namespace) {
        this.definedNamespaces.put(namespace, prefix);
    }

    void add(Resource<?> subject, URIRef predicate, Node object) {
        if (object instanceof Literal) {
            this.getOrCreateIndividual(subject).addAssertion(predicate, (Literal)object);
        } else {
            IndividualImpl target = this.getOrCreateIndividual(subject);
            IndividualImpl linked = this.getOrCreateIndividual((Resource)object);
            target.addLink(predicate, linked);
        }
        this.collectNamespace((Node)subject);
        this.collectNamespace((Node)predicate);
        this.collectNamespace(object);
    }

    @Override
    public Resource<?> getBase() {
        return this.base;
    }

    @Override
    public Map<String, String> getNamespaces() {
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.definedNamespaces.entrySet()) {
            if (!this.usedNamespaces.contains(entry.getKey())) continue;
            mappings.put(entry.getKey(), entry.getValue());
        }
        return mappings;
    }

    @Override
    public Set<Resource<?>> getIndividualIdentities() {
        return Collections.unmodifiableSet(this.subjects);
    }

    @Override
    public IndividualImpl getIndividual(Resource<?> object) {
        return this.individuals.get(object);
    }

    @Override
    public Iterator<Individual> iterator() {
        return new IndividualIterator(this.subjects.iterator());
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder out = new StringBuilder();
        out.append("Graph(").append(this.base).append(") {").append(nl);
        for (Individual i : this) {
            if (i.isReference()) continue;
            String string = i.toString();
            string = string.replace(nl, nl.concat("\t"));
            out.append("\t").append(string).append(nl);
        }
        out.append("}");
        return out.toString();
    }

    private final class IndividualIterator
    implements Iterator<Individual> {
        private final Iterator<Resource<?>> subjects;

        private IndividualIterator(Iterator<Resource<?>> subjects) {
            this.subjects = subjects;
        }

        @Override
        public boolean hasNext() {
            return this.subjects.hasNext();
        }

        @Override
        public Individual next() {
            return (Individual)GraphImpl.this.individuals.get(this.subjects.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove individuals");
        }
    }
}

