/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.ldp4j.rdf.Literal;
import org.ldp4j.rdf.Node;
import org.ldp4j.rdf.Resource;
import org.ldp4j.rdf.URIRef;
import org.ldp4j.rdf.bean.impl.model.Assertions;
import org.ldp4j.rdf.bean.impl.model.Individual;
import org.ldp4j.rdf.bean.impl.model.IndividualImpl;

final class AssertionsImpl
implements Assertions {
    private final URIRef predicate;
    private final SortedSet<Literal<?>> values;
    private final Map<Resource<?>, IndividualImpl> links;
    private boolean hasBlankNodes = false;

    AssertionsImpl(URIRef predicate) {
        this.predicate = predicate;
        this.values = new TreeSet(new LiteralComparator());
        this.links = new HashMap();
    }

    void add(Literal<?> value) {
        this.values.add(value);
    }

    void add(IndividualImpl individual) {
        this.links.put(individual.getIdentity(), individual);
    }

    private List<Node> getValues() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.values);
        TreeSet<Individual> sortedLinks = new TreeSet<Individual>(new IndividualComparator());
        sortedLinks.addAll(this.links.values());
        for (IndividualImpl individualImpl : sortedLinks) {
            result.add((Node)individualImpl.getIdentity());
        }
        return result;
    }

    public String toString() {
        return this.getPredicate() + (this.hasBlankNodes ? "* : " : " : ") + this.getValues();
    }

    @Override
    public Iterator<Node> iterator() {
        return this.getValues().iterator();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public URIRef getPredicate() {
        return this.predicate;
    }

    @Override
    public Set<Literal<?>> getLiterals() {
        return this.values;
    }

    @Override
    public Set<Individual> getIndividuals() {
        return new HashSet<Individual>(this.links.values());
    }

    private static final class IndividualComparator
    implements Comparator<Individual>,
    Serializable {
        private static final long serialVersionUID = -1532046353145514095L;

        private IndividualComparator() {
        }

        @Override
        public int compare(Individual i1, Individual i2) {
            int result = this.evalAnon(i1) - this.evalAnon(i2);
            if (result == 0 && (result = this.evalRef(i1) - this.evalRef(i2)) == 0) {
                result = i1.getIdentity().toString().compareTo(i2.getIdentity().toString());
            }
            return result;
        }

        int evalAnon(Individual i1) {
            return i1.isAnonymous() ? 1 : 0;
        }

        int evalRef(Individual i1) {
            return i1.isReference() ? 0 : 1;
        }
    }

    private static final class LiteralComparator
    implements Comparator<Literal<?>>,
    Serializable {
        private static final long serialVersionUID = -4543665504300717043L;

        private LiteralComparator() {
        }

        @Override
        public int compare(Literal<?> o1, Literal<?> o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

