/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ldp4j.rdf.bean.Type;
import org.ldp4j.rdf.bean.Vocabulary;

final class VocabularyDefinition
implements Vocabulary {
    private final String namespace;
    private final String preferredPrefix;
    private final List<Type> types;

    VocabularyDefinition(String namespace, String preferredPrefix, List<Type> types) {
        this.namespace = namespace;
        this.preferredPrefix = preferredPrefix;
        this.types = this.safeClone(types);
    }

    private <T> List<T> safeClone(List<T> data) {
        return Collections.unmodifiableList(new ArrayList<T>(data));
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getPreferredPrefix() {
        return this.preferredPrefix;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public Type lookup(Class<?> clazz) {
        for (Type type : this.types) {
            if (type.getBound() != clazz) continue;
            return type;
        }
        return null;
    }

    String toShortString() {
        return String.format("Vocabulary {preferredPrefix=%s, namespace=%s}", this.preferredPrefix, this.namespace);
    }
}

