/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.rdf.bean.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class TypeSupport {
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE = new HashMap();
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER;

    private TypeSupport() {
    }

    public static boolean isPrimitive(Class<?> clazz) {
        return PRIMITIVE_TO_WRAPPER.containsKey(clazz);
    }

    public static boolean isWrapper(Class<?> clazz) {
        return WRAPPER_TO_PRIMITIVE.containsKey(clazz);
    }

    public static boolean isLiteral(Class<?> clazz) {
        return TypeSupport.isPrimitive(clazz) || TypeSupport.isWrapper(clazz) || CharSequence.class.isAssignableFrom(clazz);
    }

    public static boolean isAggregation(Class<?> clazz) {
        return List.class == clazz || Set.class == clazz;
    }

    public static boolean isRepeatable(Class<?> clazz) {
        return TypeSupport.isAggregation(clazz) && !Set.class.isAssignableFrom(clazz);
    }

    public static Type getAggregatedType(Type type) {
        assert (type instanceof ParameterizedType) : "Invalid aggregation type: expected a Set or List but got '" + type + "'";
        ParameterizedType pt = (ParameterizedType)type;
        Type[] actualTypeArguments = pt.getActualTypeArguments();
        assert (actualTypeArguments.length == 1) : "Invalid number of type arguments: expected 1, but got " + actualTypeArguments.length;
        return actualTypeArguments[0];
    }

    static {
        WRAPPER_TO_PRIMITIVE.put(Character.class, Character.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Byte.class, Byte.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Short.class, Short.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Integer.class, Integer.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Long.class, Long.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Double.class, Double.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Float.class, Float.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Boolean.class, Boolean.TYPE);
        PRIMITIVE_TO_WRAPPER = new HashMap();
        for (Map.Entry<Class<?>, Class<?>> entry : WRAPPER_TO_PRIMITIVE.entrySet()) {
            PRIMITIVE_TO_WRAPPER.put(entry.getValue(), entry.getKey());
        }
    }
}

